/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class TransferableList
extends ArrayList
implements Transferable {
    public TransferableList() {
    }

    public TransferableList(Collection c) {
        super(c);
    }

    public TransferableList(int initialCapacity) {
        super(initialCapacity);
    }

    public DataFlavor[] getTransferDataFlavors() {
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        int i = 0;
        while (i < this.size()) {
            Transferable obj = (Transferable)this.get(i);
            DataFlavor[] objFlavs = obj.getTransferDataFlavors();
            int j = 0;
            while (j < objFlavs.length) {
                flavors.add(objFlavs[j]);
                ++j;
            }
            ++i;
        }
        DataFlavor[] flavArray = new DataFlavor[flavors.size()];
        int i2 = 0;
        Iterator iter = flavors.iterator();
        while (iter.hasNext()) {
            flavArray[i2++] = (DataFlavor)iter.next();
        }
        return flavArray;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean supported = false;
        DataFlavor[] flavors = this.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            if (flavor.equals(flavors[i])) {
                supported = true;
                break;
            }
            ++i;
        }
        return supported;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < this.size()) {
            Transferable obj = (Transferable)this.get(i);
            if (obj.isDataFlavorSupported(flavor)) {
                data.add(obj.getTransferData(flavor));
            }
            ++i;
        }
        if (data.size() == 0) {
            throw new UnsupportedFlavorException(flavor);
        }
        return data.toArray();
    }
}

