/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import jsky.util.gui.JTextFieldDouble;

public class JTextFieldDoubleTableCellRenderer
extends JTextFieldDouble
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public JTextFieldDoubleTableCellRenderer() {
        noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        this.setBorder(noFocusBorder);
        this.setHorizontalAlignment(4);
        this.setNormalColor(Color.black);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(this.getSelectionColor());
        } else {
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(value);
        return this;
    }

    protected void setValue(Object value) {
        if (value instanceof Double) {
            this.setText((Double)value);
        } else if (value != null) {
            this.setText(value.toString());
        }
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

