/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.RepaintManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsky.util.gui.DialogUtil;

public class PrintableJTable
extends JTable
implements Printable {
    private int fMaxNumPage = 1;
    private JLabel fTitle = null;

    public PrintableJTable() {
    }

    public PrintableJTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public PrintableJTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public PrintableJTable(TableModel dm) {
        super(dm);
    }

    public PrintableJTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public PrintableJTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public PrintableJTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public String getTitle() {
        if (this.fTitle != null) {
            return this.fTitle.getText();
        }
        return "";
    }

    public void setTitle(String title) {
        this.fTitle = new JLabel(title);
    }

    public void setTitle(String title, Font titleFont) {
        this.fTitle = new JLabel(title);
        this.fTitle.setFont(titleFont);
    }

    public void print(String title) throws PrinterException {
        this.setTitle(title);
        this.print();
    }

    public boolean print() throws PrinterException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setJobName(this.fTitle != null ? this.fTitle.getText() : "Table Contents");
        PageFormat format = job.pageDialog(job.defaultPage());
        job.setPrintable(this, format);
        try {
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (Exception e) {
            DialogUtil.error(e);
            return false;
        }
        return true;
    }

    public int print(Graphics pg, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex == 0) {
            this.fMaxNumPage = 1;
        }
        if (pageIndex >= this.fMaxNumPage) {
            return 1;
        }
        pg.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int wPage = (int)pageFormat.getImageableWidth();
        int hPage = (int)pageFormat.getImageableHeight();
        double scaleFactor = wPage >= this.getWidth() ? 0.5 : (double)wPage / (double)this.getWidth();
        int y = 0;
        RepaintManager rm = RepaintManager.currentManager(this.getRootPane());
        rm.setDoubleBufferingEnabled(false);
        FontMetrics fm = null;
        if (this.fTitle != null) {
            double titleScale = scaleFactor;
            Font titleFont = this.fTitle.getFont();
            float fontSize = (float)((double)titleFont.getSize2D() * titleScale);
            titleFont = titleFont.deriveFont(fontSize);
            pg.setFont(titleFont);
            fm = pg.getFontMetrics();
            int titleSize = fm.stringWidth(this.fTitle.getText());
            if (titleSize > wPage) {
                int scaledFontSize = (int)(fontSize * (float)wPage / (float)titleSize);
                titleFont = this.fTitle.getFont().deriveFont((float)scaledFontSize);
                pg.setFont(titleFont);
                fm = pg.getFontMetrics();
            }
            Font fn = pg.getFont();
            pg.drawString(this.fTitle.getText(), 0, y += fm.getAscent());
            y += 20;
        }
        Font headerFont = this.getFont().deriveFont(1);
        double boldScaleFactor = scaleFactor * (double)(this.getFont().getSize2D() / headerFont.getSize2D());
        if (boldScaleFactor != 1.0) {
            int headerFontSize = (int)((double)headerFont.getSize2D() * boldScaleFactor);
            headerFont = headerFont.deriveFont((float)headerFontSize);
        }
        pg.setFont(headerFont);
        fm = pg.getFontMetrics();
        TableColumnModel colModel = this.getColumnModel();
        int nColumns = colModel.getColumnCount();
        int[] widths = new int[nColumns];
        int[] x = new int[nColumns];
        x[0] = 0;
        int h = fm.getAscent();
        y += h;
        int nCol = 0;
        while (nCol < nColumns) {
            TableColumn tk = colModel.getColumn(nCol);
            widths[nCol] = tk.getWidth();
            if (nCol + 1 < nColumns) {
                x[nCol + 1] = x[nCol] + (int)((double)widths[nCol] * scaleFactor);
            }
            if (widths[nCol] > 0) {
                String title = (String)tk.getIdentifier();
                pg.drawString(title, x[nCol], y);
            }
            ++nCol;
        }
        Font columnFont = this.getFont();
        if (scaleFactor != 1.0) {
            float columnFontSize = (float)((double)this.getFont().getSize2D() * scaleFactor);
            columnFont = columnFont.deriveFont(columnFontSize);
        }
        pg.setFont(columnFont);
        fm = pg.getFontMetrics();
        int header = y;
        h = fm.getHeight();
        int rowH = Math.max((int)((double)h * 1.5), 10);
        int rowPerPage = (hPage - header) / rowH;
        this.fMaxNumPage = Math.max((int)Math.ceil((double)this.getRowCount() / (double)rowPerPage), 1);
        TableModel tblModel = this.getModel();
        int iniRow = pageIndex * rowPerPage;
        int endRow = Math.min(this.getRowCount(), iniRow + rowPerPage);
        y += 5;
        int nRow = iniRow;
        while (nRow < endRow) {
            y += h + 3;
            nCol = 0;
            while (nCol < nColumns) {
                if (widths[nCol] > 0) {
                    int col = this.getColumnModel().getColumn(nCol).getModelIndex();
                    Object obj = this.getModel().getValueAt(nRow, col);
                    TableCellRenderer cellRend = this.getCellRenderer(nRow, col);
                    Component c = cellRend.getTableCellRendererComponent(this, obj, false, false, nRow, col);
                    String str = c instanceof JLabel ? ((JLabel)c).getText() : obj.toString();
                    pg.drawString(str, x[nCol], y);
                }
                ++nCol;
            }
            ++nRow;
        }
        rm.setDoubleBufferingEnabled(true);
        return 0;
    }
}

