/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.event.EventListenerList;
import jsky.util.gui.BasicWindowMonitor;

public class ToggleButtonPanel
extends JPanel {
    protected EventListenerList listenerList = new EventListenerList();
    JToggleButton[] buttons;
    JToggleButton selectedButton;
    boolean enableMultipleSelection;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public ToggleButtonPanel(String[] names, int nrows, int ncols, boolean enableMultipleSelection, int hgap, int vgap) {
        this.setLayout(new GridLayout(nrows, ncols, hgap, vgap));
        this.buttons = new JToggleButton[names.length];
        ButtonGroup group = new ButtonGroup();
        this.enableMultipleSelection = enableMultipleSelection;
        int i = 0;
        while (i < names.length) {
            if (names[i] == null) {
                this.add(new JLabel());
            } else {
                this.buttons[i] = new JToggleButton(names[i]);
                this.buttons[i].setFocusPainted(false);
                this.buttons[i].setFont(this.buttons[i].getFont().deriveFont(0));
                this.buttons[i].setBorder(new BevelBorder(0));
                this.buttons[i].addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        ToggleButtonPanel.this.selectedButton = (JToggleButton)e.getItem();
                        if (e.getStateChange() == 1) {
                            ToggleButtonPanel.this.selectedButton.setBorder(new BevelBorder(1));
                            ToggleButtonPanel.this.fireItemEvent(e);
                        } else {
                            ToggleButtonPanel.this.selectedButton.setBorder(new BevelBorder(0));
                            ToggleButtonPanel.this.selectedButton = null;
                            if (ToggleButtonPanel.this.enableMultipleSelection) {
                                ToggleButtonPanel.this.fireItemEvent(e);
                            }
                        }
                    }
                });
                if (!enableMultipleSelection) {
                    group.add(this.buttons[i]);
                }
                this.add(this.buttons[i]);
            }
            ++i;
        }
    }

    public ToggleButtonPanel(String[] names, int nrows, int ncols, boolean enableMultipleSelection) {
        this(names, nrows, ncols, enableMultipleSelection, 0, 0);
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = ToggleButtonPanel.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = ToggleButtonPanel.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, l);
    }

    protected void fireItemEvent(ItemEvent itemEvent) {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ItemListener == null ? ToggleButtonPanel.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)listeners[i + 1]).itemStateChanged(itemEvent);
            }
            i -= 2;
        }
    }

    public JToggleButton getSelected() {
        return this.selectedButton;
    }

    public int getNumberOfButtons() {
        return this.buttons.length;
    }

    public JToggleButton getButton(int n) {
        return this.buttons[n];
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("ToggleButtonPanel");
        String[] names = new String[]{"one", "two", "three", "four", "five", null, "six", "seven", "eight", "eight", "nine", "ten"};
        ToggleButtonPanel panel = new ToggleButtonPanel(names, 0, 4, true, 1, 1);
        panel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JToggleButton bb = (JToggleButton)e.getItem();
                if (e.getStateChange() == 1) {
                    System.out.println("Selected " + bb.getText());
                } else {
                    System.out.println("Deselected " + bb.getText());
                }
            }
        });
        frame.getContentPane().add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

