/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.TiledImage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.jaiutil.HDXDecodeParam;
import uk.ac.starlink.jaiutil.NDArrayData;
import uk.ac.starlink.jaiutil.NDArrayDataByte;
import uk.ac.starlink.jaiutil.NDArrayDataDouble;
import uk.ac.starlink.jaiutil.NDArrayDataFloat;
import uk.ac.starlink.jaiutil.NDArrayDataInt;
import uk.ac.starlink.jaiutil.NDArrayDataShort;
import uk.ac.starlink.jaiutil.SimpleRenderedImage;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxIO;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.ndx.XMLNdxHandler;

public class HDXImage
extends SimpleRenderedImage {
    protected List ndxs = new ArrayList();
    protected NDArray ndArray = null;
    protected NDArrayData ndArrayData;
    protected long[] axes = null;
    protected int ndxIndex = -1;
    protected int dataType;
    protected static int defaultTileWidth = 128;
    protected static int defaultTileHeight = 128;
    protected TileCache tileCache = JAI.getDefaultInstance().getTileCache();
    protected HDXDecodeParam param;
    protected static int previewSize = 152;
    protected boolean empty = false;
    private float scale = 1.0f;
    private int subsample = 1;

    public HDXImage(SeekableStream input, HDXDecodeParam param, int page) throws IOException {
        this.param = param;
        XMLNdxHandler xmlHandler = XMLNdxHandler.getInstance();
        StreamSource xmlSource = new StreamSource((InputStream)input);
        Ndx ndx = xmlHandler.makeNdx(xmlSource, AccessMode.READ);
        this.ndxs.add(ndx);
        this.setNDX(page);
    }

    public HDXImage(Source source) throws IOException {
        XMLNdxHandler xmlHandler = XMLNdxHandler.getInstance();
        Ndx ndx = xmlHandler.makeNdx(source, AccessMode.READ);
        this.ndxs.add(ndx);
        this.setNDX(0);
    }

    public HDXImage(String fileOrUrl) throws IOException {
        NdxIO ndxIO = new NdxIO();
        Ndx ndx = ndxIO.makeNdx(fileOrUrl, AccessMode.READ);
        this.ndxs.add(ndx);
        this.setNDX(0);
    }

    public HDXImage(Ndx ndx) throws IOException {
        this.ndxs.add(ndx);
        this.setNDX(0);
    }

    public HDXImage(Document document, HDXDecodeParam param, int page) throws IOException {
        this(document.getDocumentElement(), page);
        this.param = param;
    }

    public HDXImage(Element element, int page) throws IOException {
        XMLNdxHandler xmlHandler = XMLNdxHandler.getInstance();
        DOMSource xmlSource = new DOMSource(element);
        Ndx ndx = xmlHandler.makeNdx(xmlSource, AccessMode.READ);
        this.ndxs.add(ndx);
        this.setNDX(page);
    }

    public int getCurrentNDXIndex() {
        return this.ndxIndex;
    }

    protected BufferedInputStream getStream(String fileOrUrl) throws IOException {
        URL url = this.getURL(fileOrUrl);
        InputStream stream = url.openStream();
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return (BufferedInputStream)stream;
    }

    protected URL getURL(String fileOrUrl) throws MalformedURLException {
        URL url = null;
        if (fileOrUrl.startsWith("http:") || fileOrUrl.startsWith("file:") || fileOrUrl.startsWith("ftp:")) {
            url = new URL(fileOrUrl);
        } else {
            File file = new File(fileOrUrl);
            url = file.getAbsoluteFile().toURL();
        }
        return url;
    }

    public int getNumNDXs() {
        if (this.ndxs != null) {
            return this.ndxs.size();
        }
        return 0;
    }

    public void setNDX(int num) throws IOException {
        if (this.ndxs == null || num >= this.ndxs.size()) {
            throw new IOException("Cannot select NDX (" + num + ")");
        }
        if (num == this.ndxIndex) {
            return;
        }
        this.close();
        this.ndxIndex = num;
        Ndx ndx = (Ndx)this.ndxs.get(this.ndxIndex);
        Requirements req = new Requirements();
        this.ndArray = Ndxs.getMaskedImage(ndx, req);
        this.axes = this.ndArray.getShape().getDims();
        if (this.axes.length <= 1) {
            this.width = 0;
            this.height = 0;
            this.empty = true;
            throw new IOException("Dimensionality of NDX should be 2");
        }
        this.scale = 1.0f;
        this.subsample = 1;
        this.initData();
    }

    public void close() throws IOException {
        if (this.ndArray != null) {
            this.ndArray.getAccess().close();
        }
    }

    public double getBadValue() {
        Number value;
        BadHandler handler;
        if (this.ndArray != null && (handler = this.ndArray.getBadHandler()) != null && (value = handler.getBadValue()) != null) {
            return value.doubleValue();
        }
        return Double.NaN;
    }

    public static void setDefaultTileWidth(int w) {
        defaultTileWidth = w;
    }

    public static int getDefaultTileWidth() {
        return defaultTileWidth;
    }

    public static void setDefaultTileHeight(int h) {
        defaultTileHeight = h;
    }

    public static int getDefaultTileHeight() {
        return defaultTileHeight;
    }

    public void clearTileCache() {
        this.tileCache.removeTiles((RenderedImage)this);
    }

    public Object getProperty(String name) {
        if (name.equals("#num_pages")) {
            return Integer.toString(this.getNumNDXs());
        }
        if (name.equals("#preview_image")) {
            return this.getPreviewImage(previewSize);
        }
        if (name.equals("#ndx_image")) {
            return this;
        }
        return null;
    }

    public String[] getPropertyNames() {
        String[] names = new String[]{"#num_pages", "#preview_image", "#ndx_image"};
        return names;
    }

    protected TiledImage getPreviewImage(int size) {
        if (size == 0 || this.empty) {
            return null;
        }
        int factor = Math.max((this.width - 1) / size + 1, (this.height - 1) / size + 1);
        if (factor <= 1) {
            return null;
        }
        int tileWidth = this.width / factor;
        int tileHeight = this.height / factor;
        SampleModel sampleModel = this.initSampleModel(tileWidth, tileHeight);
        ColorModel colorModel = this.initColorModel();
        TiledImage tiledImage = new TiledImage(0, 0, tileWidth, tileHeight, 0, 0, sampleModel, colorModel);
        Point origin = new Point(0, 0);
        Raster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, (Point)origin);
        try {
            raster = this.ndArrayData.getPreviewImage(raster, factor);
        }
        catch (EOFException e) {
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        if (raster == null) {
            return null;
        }
        tiledImage.setData(raster);
        return tiledImage;
    }

    public ColorModel initColorModel() {
        return ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
    }

    public SampleModel initSampleModel(int tileWidth, int tileHeight) {
        int[] bandOffsets = new int[]{0};
        int pixelStride = 1;
        int scanlineStride = tileWidth;
        return RasterFactory.createPixelInterleavedSampleModel((int)this.dataType, (int)tileWidth, (int)tileHeight, (int)pixelStride, (int)scanlineStride, (int[])bandOffsets);
    }

    public void initData() throws IOException {
        if (this.empty) {
            this.ndArrayData = new NDArrayDataDouble(this.ndArray, new int[]{2, 2});
            this.dataType = 5;
        } else {
            Type nativeType = this.ndArray.getType();
            if (nativeType == Type.SHORT) {
                this.ndArrayData = new NDArrayDataShort(this.ndArray);
                this.dataType = 2;
            } else if (nativeType == Type.SHORT) {
                this.ndArrayData = new NDArrayDataByte(this.ndArray);
                this.dataType = 0;
            } else if (nativeType == Type.INT) {
                this.ndArrayData = new NDArrayDataInt(this.ndArray);
                this.dataType = 3;
            } else if (nativeType == Type.FLOAT) {
                this.ndArrayData = new NDArrayDataFloat(this.ndArray);
                this.dataType = 4;
            } else if (nativeType == Type.DOUBLE) {
                this.ndArrayData = new NDArrayDataDouble(this.ndArray);
                this.dataType = 5;
            } else {
                throw new RuntimeException("Invalid data type" + this.ndArray.getType());
            }
        }
        this.initImage();
    }

    private void initImage() throws IOException {
        this.width = (int)this.axes[this.axes.length - 2];
        this.height = (int)this.axes[this.axes.length - 1];
        if (this.width != 0 && this.height != 0) {
            if (this.subsample != 1) {
                this.width /= this.subsample;
                this.height /= this.subsample;
            }
            this.tileWidth = defaultTileWidth;
            if (this.width / this.tileWidth <= 1) {
                this.tileWidth = this.width;
            }
            this.tileHeight = defaultTileHeight;
            if (this.height / this.tileHeight <= 1) {
                this.tileHeight = this.height;
            }
            this.sampleModel = this.initSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = this.initColorModel();
        }
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (this.empty) {
            return RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)new Point(0, 0));
        }
        Raster tile = this.tileCache.getTile((RenderedImage)this, tileX, tileY);
        if (tile == null) {
            Point origin = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
            tile = RasterFactory.createWritableRaster((SampleModel)this.sampleModel, (Point)origin);
            this.fillTile(tile);
            this.tileCache.add((RenderedImage)this, tileX, tileY, tile);
        }
        return tile;
    }

    protected Raster fillTile(Raster tile) {
        try {
            this.ndArrayData.getTile(tile, this.subsample, this.width, this.height);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return tile;
    }

    public static void setPreviewSize(int i) {
        previewSize = i;
    }

    public static int getPreviewSize() {
        return previewSize;
    }

    public Ndx getCurrentNDX() {
        return (Ndx)this.ndxs.get(this.ndxIndex);
    }

    public int getRealWidth() {
        return (int)this.axes[this.axes.length - 2];
    }

    public int getRealHeight() {
        return (int)this.axes[this.axes.length - 1];
    }

    public boolean setScale(float scale) throws IOException {
        boolean needsUpdate = false;
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        if (scale != this.scale) {
            needsUpdate = true;
            this.scale = scale;
            this.subsample = scale < 1.0f ? Math.round(1.0f / scale) : 1;
            this.tileCache.flush();
            this.initImage();
        }
        return needsUpdate;
    }

    public float getScale() {
        return this.scale;
    }

    public int getSubsample() {
        return this.subsample;
    }
}

