/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import java.awt.image.Raster;
import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Requirements;

public abstract class NDArrayData {
    protected ArrayAccess tiler;
    protected int width;
    protected int height;
    protected int naxis;

    public NDArrayData(NDArray nda) throws IOException {
        Requirements req = new Requirements(AccessMode.READ).setRandom(true);
        nda = NDArrays.toRequiredArray(nda, req);
        this.tiler = nda.getAccess();
        long[] axes = null;
        try {
            axes = nda.getShape().getDims();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.naxis = axes.length;
        this.width = (int)axes[this.naxis - 2];
        this.height = (int)axes[this.naxis - 1];
    }

    public NDArrayData(NDArray nda, int[] axes) throws IOException {
        Requirements req = new Requirements(AccessMode.READ).setRandom(true);
        nda = NDArrays.toRequiredArray(nda, req);
        this.tiler = nda.getAccess();
        this.naxis = axes.length;
        this.width = axes[this.naxis - 2];
        this.height = axes[this.naxis - 1];
    }

    protected void fillTile(Object destArray, int x, int y, int w, int h) throws IOException {
        int[] lengths;
        long[] corners;
        ++x;
        ++y;
        switch (this.naxis) {
            case 2: {
                corners = new long[]{x, y};
                lengths = new int[]{w, h};
                break;
            }
            case 3: {
                corners = new long[]{0L, y, x};
                lengths = new int[]{0, h, w};
                break;
            }
            case 4: {
                corners = new long[]{0L, 0L, y, x};
                lengths = new int[]{0, 0, h, w};
                break;
            }
            default: {
                throw new RuntimeException("Unsupported number of axes");
            }
        }
        long[] origins = this.tiler.getShape().getOrigin();
        int i = 0;
        while (i < origins.length) {
            int n = i;
            corners[n] = corners[n] + (origins[i] - 1L);
            ++i;
        }
        try {
            this.tiler.readTile(destArray, new NDShape(corners, lengths));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract Raster getTile(Raster var1, int var2, int var3, int var4) throws IOException;

    public abstract Raster getPreviewImage(Raster var1, int var2) throws IOException;
}

