/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.jaiutil;

import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.jaiutil.NDArrayData;

public class NDArrayDataByte
extends NDArrayData {
    public NDArrayDataByte(NDArray nda) throws IOException {
        super(nda);
    }

    public NDArrayDataByte(NDArray nda, int[] axes) throws IOException {
        super(nda, axes);
    }

    public Raster getTile(Raster tile, int subsample, int scaledWidth, int scaledHeight) throws IOException {
        DataBufferByte dataBuffer = (DataBufferByte)tile.getDataBuffer();
        byte[] destArray = dataBuffer.getData();
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int x0 = tile.getMinX();
        int y0 = tile.getMinY();
        if (subsample == 1) {
            this.fillTile(destArray, x0, y0, tw, th);
        } else {
            int x1 = Math.min(x0 + tw - 1, scaledWidth - 1);
            int y1 = Math.min(y0 + th - 1, scaledHeight - 1);
            int j = y0;
            while (j <= y1) {
                int dst = (j - y0) * tw;
                long src = (j * this.width + x0) * subsample;
                int i = x0;
                while (i <= x1) {
                    this.tiler.setOffset(src);
                    this.tiler.read(destArray, dst++, 1);
                    src += (long)subsample;
                    ++i;
                }
                ++j;
            }
        }
        return tile;
    }

    public Raster getPreviewImage(Raster tile, int factor) throws IOException {
        DataBufferByte dataBuffer = (DataBufferByte)tile.getDataBuffer();
        byte[] destArray = dataBuffer.getData();
        byte[] line = new byte[this.width];
        int tw = tile.getWidth();
        int th = tile.getHeight();
        int w = tw * factor;
        int h = th * factor;
        int n = 0;
        int m = 0;
        try {
            int j = 0;
            while (j < h) {
                n = m++ * tw;
                this.fillTile(line, 0, j, this.width, 1);
                int i = 0;
                while (i < w) {
                    destArray[n++] = line[i];
                    i += factor;
                }
                j += factor;
            }
            return tile;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

