/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.util.Arrays;
import uk.ac.starlink.array.Type;

public abstract class BadHandler {
    private final Number badValue;
    private final Type type;
    private static final BadHandler BYTE_NULL_HANDLER = new NullHandler(Type.BYTE){
        private final byte byteBad = Type.BYTE.defaultBadValue().byteValue();

        public final void putBad(Object array, int pos) {
            ((byte[])array)[pos] = this.byteBad;
        }

        public final void putBad(Object array, int start, int size) {
            Arrays.fill((byte[])array, start, start + size, this.byteBad);
        }

        public final Number makeNumber(Object array, int pos) {
            return new Byte(((byte[])array)[pos]);
        }

        public final ArrayHandler arrayHandler(Object arr) {
            return new NullArrayHandler(this, arr){
                byte[] array;
                private final /* synthetic */ Object val$arr;
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                    this.val$arr = val$arr;
                    this.array = (byte[])this.val$arr;
                }

                public void putBad(int pos) {
                    this.array[pos] = 1.access$600(this.this$0);
                }
            };
        }

        static /* synthetic */ byte access$600(1 x0) {
            return x0.byteBad;
        }
    };
    private static final BadHandler SHORT_NULL_HANDLER = new NullHandler(Type.SHORT){
        private final short shortBad = Type.SHORT.defaultBadValue().shortValue();

        public final void putBad(Object array, int pos) {
            ((short[])array)[pos] = this.shortBad;
        }

        public final void putBad(Object array, int start, int size) {
            Arrays.fill((short[])array, start, start + size, this.shortBad);
        }

        public final Number makeNumber(Object array, int pos) {
            return new Short(((short[])array)[pos]);
        }

        public final ArrayHandler arrayHandler(Object arr) {
            return new NullArrayHandler(this, arr){
                short[] array;
                private final /* synthetic */ Object val$arr;
                private final /* synthetic */ 5 this$0;
                {
                    this.this$0 = this$0;
                    this.val$arr = val$arr;
                    this.array = (short[])this.val$arr;
                }

                public void putBad(int pos) {
                    this.array[pos] = 5.access$700(this.this$0);
                }
            };
        }

        static /* synthetic */ short access$700(5 x0) {
            return x0.shortBad;
        }
    };
    private static final BadHandler INT_NULL_HANDLER = new NullHandler(Type.INT){
        private final int intBad = Type.INT.defaultBadValue().intValue();

        public final void putBad(Object array, int pos) {
            ((int[])array)[pos] = this.intBad;
        }

        public final void putBad(Object array, int start, int size) {
            Arrays.fill((int[])array, start, start + size, this.intBad);
        }

        public final Number makeNumber(Object array, int pos) {
            return new Integer(((int[])array)[pos]);
        }

        public final ArrayHandler arrayHandler(Object arr) {
            return new NullArrayHandler(this, arr){
                int[] array;
                private final /* synthetic */ Object val$arr;
                private final /* synthetic */ 9 this$0;
                {
                    this.this$0 = this$0;
                    this.val$arr = val$arr;
                    this.array = (int[])this.val$arr;
                }

                public void putBad(int pos) {
                    this.array[pos] = 9.access$800(this.this$0);
                }
            };
        }

        static /* synthetic */ int access$800(9 x0) {
            return x0.intBad;
        }
    };
    private static final BadHandler FLOAT_DEFAULT_HANDLER = new BadHandler(Type.FLOAT, Type.FLOAT.defaultBadValue()){
        private final float floatBad = Type.FLOAT.defaultBadValue().floatValue();

        public final boolean isBad(Object array, int pos) {
            float val = ((float[])array)[pos];
            return Float.isNaN(val);
        }

        public final void putBad(Object array, int pos) {
            ((float[])array)[pos] = this.floatBad;
        }

        public final void putBad(Object array, int start, int size) {
            Arrays.fill((float[])array, start, start + size, this.floatBad);
        }

        public final Number makeNumber(Object array, int pos) {
            float val = ((float[])array)[pos];
            return Float.isNaN(val) ? null : new Float(val);
        }

        public final ArrayHandler arrayHandler(Object arr) {
            return new ArrayHandler(this, arr){
                float[] array;
                private final /* synthetic */ Object val$arr;
                private final /* synthetic */ 13 this$0;
                {
                    this.this$0 = this$0;
                    this.val$arr = val$arr;
                    this.array = (float[])this.val$arr;
                }

                public boolean isBad(int pos) {
                    float val = this.array[pos];
                    return Float.isNaN(val);
                }

                public void putBad(int pos) {
                    this.array[pos] = 13.access$900(this.this$0);
                }
            };
        }

        static /* synthetic */ float access$900(13 x0) {
            return x0.floatBad;
        }
    };
    private static final BadHandler DOUBLE_DEFAULT_HANDLER = new BadHandler(Type.DOUBLE, Type.DOUBLE.defaultBadValue()){
        private final double doubleBad = Type.DOUBLE.defaultBadValue().doubleValue();

        public final boolean isBad(Object array, int pos) {
            double val = ((double[])array)[pos];
            return Double.isNaN(val);
        }

        public final void putBad(Object array, int pos) {
            ((double[])array)[pos] = this.doubleBad;
        }

        public final void putBad(Object array, int start, int size) {
            Arrays.fill((double[])array, start, start + size, this.doubleBad);
        }

        public final Number makeNumber(Object array, int pos) {
            double val = ((double[])array)[pos];
            return Double.isNaN(val) ? null : new Double(val);
        }

        public final ArrayHandler arrayHandler(Object arr) {
            return new ArrayHandler(this, arr){
                double[] array;
                private final /* synthetic */ Object val$arr;
                private final /* synthetic */ 17 this$0;
                {
                    this.this$0 = this$0;
                    this.val$arr = val$arr;
                    this.array = (double[])this.val$arr;
                }

                public boolean isBad(int pos) {
                    double val = this.array[pos];
                    return Double.isNaN(val);
                }

                public void putBad(int pos) {
                    this.array[pos] = 17.access$1000(this.this$0);
                }
            };
        }

        static /* synthetic */ double access$1000(17 x0) {
            return x0.doubleBad;
        }
    };

    public abstract boolean isBad(Object var1, int var2);

    public abstract void putBad(Object var1, int var2, int var3);

    public abstract void putBad(Object var1, int var2);

    public abstract Number makeNumber(Object var1, int var2);

    public abstract ArrayHandler arrayHandler(Object var1);

    protected BadHandler(Type type, Number badValue) {
        this.type = type;
        this.badValue = badValue;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public static BadHandler getHandler(Type type, Number badValue) {
        if (type == Type.BYTE) {
            if (BadHandler.equalValues(type, badValue, null)) {
                return BYTE_NULL_HANDLER;
            }
            final byte byteBad = (Byte)badValue;
            return new BadHandler(type, badValue){

                public final boolean isBad(Object array, int pos) {
                    return ((byte[])array)[pos] == byteBad;
                }

                public final void putBad(Object array, int pos) {
                    ((byte[])array)[pos] = byteBad;
                }

                public final void putBad(Object array, int start, int size) {
                    Arrays.fill((byte[])array, start, start + size, byteBad);
                }

                public final Number makeNumber(Object array, int pos) {
                    byte val = ((byte[])array)[pos];
                    return val == byteBad ? null : new Byte(val);
                }

                public final ArrayHandler arrayHandler(Object arr) {
                    return new ArrayHandler(this, arr){
                        byte[] array;
                        private final /* synthetic */ Object val$arr;
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$arr = val$arr;
                            this.array = (byte[])this.val$arr;
                        }

                        public boolean isBad(int pos) {
                            return this.array[pos] == 3.access$000(this.this$0);
                        }

                        public void putBad(int pos) {
                            this.array[pos] = 3.access$000(this.this$0);
                        }
                    };
                }

                static /* synthetic */ byte access$000(3 x0) {
                    return x0.byteBad;
                }
            };
        }
        if (type == Type.SHORT) {
            if (BadHandler.equalValues(type, badValue, null)) {
                return SHORT_NULL_HANDLER;
            }
            final short shortBad = (Short)badValue;
            return new BadHandler(type, badValue){

                public final boolean isBad(Object array, int pos) {
                    return ((short[])array)[pos] == shortBad;
                }

                public final void putBad(Object array, int pos) {
                    ((short[])array)[pos] = shortBad;
                }

                public final void putBad(Object array, int start, int size) {
                    Arrays.fill((short[])array, start, start + size, shortBad);
                }

                public final Number makeNumber(Object array, int pos) {
                    short val = ((short[])array)[pos];
                    return val == shortBad ? null : new Short(val);
                }

                public final ArrayHandler arrayHandler(Object arr) {
                    return new ArrayHandler(this, arr){
                        short[] array;
                        private final /* synthetic */ Object val$arr;
                        private final /* synthetic */ 7 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$arr = val$arr;
                            this.array = (short[])this.val$arr;
                        }

                        public boolean isBad(int pos) {
                            return this.array[pos] == 7.access$100(this.this$0);
                        }

                        public void putBad(int pos) {
                            this.array[pos] = 7.access$100(this.this$0);
                        }
                    };
                }

                static /* synthetic */ short access$100(7 x0) {
                    return x0.shortBad;
                }
            };
        }
        if (type == Type.INT) {
            if (BadHandler.equalValues(type, badValue, null)) {
                return INT_NULL_HANDLER;
            }
            final int intBad = (Integer)badValue;
            return new BadHandler(type, badValue){

                public final boolean isBad(Object array, int pos) {
                    return ((int[])array)[pos] == intBad;
                }

                public final void putBad(Object array, int pos) {
                    ((int[])array)[pos] = intBad;
                }

                public final void putBad(Object array, int start, int size) {
                    Arrays.fill((int[])array, start, start + size, intBad);
                }

                public final Number makeNumber(Object array, int pos) {
                    int val = ((int[])array)[pos];
                    return val == intBad ? null : new Integer(val);
                }

                public final ArrayHandler arrayHandler(Object arr) {
                    return new ArrayHandler(this, arr){
                        int[] array;
                        private final /* synthetic */ Object val$arr;
                        private final /* synthetic */ 11 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$arr = val$arr;
                            this.array = (int[])this.val$arr;
                        }

                        public boolean isBad(int pos) {
                            return this.array[pos] == 11.access$200(this.this$0);
                        }

                        public void putBad(int pos) {
                            this.array[pos] = 11.access$200(this.this$0);
                        }
                    };
                }

                static /* synthetic */ int access$200(11 x0) {
                    return x0.intBad;
                }
            };
        }
        if (type == Type.FLOAT) {
            if (BadHandler.equalValues(type, badValue, type.defaultBadValue())) {
                return FLOAT_DEFAULT_HANDLER;
            }
            final float floatBad = ((Float)badValue).floatValue();
            return new BadHandler(type, badValue){

                public final boolean isBad(Object array, int pos) {
                    float val = ((float[])array)[pos];
                    return val == floatBad || Float.isNaN(val);
                }

                public final void putBad(Object array, int pos) {
                    ((float[])array)[pos] = floatBad;
                }

                public final void putBad(Object array, int start, int size) {
                    Arrays.fill((float[])array, start, start + size, floatBad);
                }

                public final Number makeNumber(Object array, int pos) {
                    float val = ((float[])array)[pos];
                    return val == floatBad || Float.isNaN(val) ? null : new Float(val);
                }

                public final ArrayHandler arrayHandler(Object arr) {
                    return new ArrayHandler(this, arr){
                        float[] array;
                        private final /* synthetic */ Object val$arr;
                        private final /* synthetic */ 15 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$arr = val$arr;
                            this.array = (float[])this.val$arr;
                        }

                        public boolean isBad(int pos) {
                            float val = this.array[pos];
                            return val == 15.access$300(this.this$0) || Float.isNaN(val);
                        }

                        public void putBad(int pos) {
                            this.array[pos] = 15.access$300(this.this$0);
                        }
                    };
                }

                static /* synthetic */ float access$300(15 x0) {
                    return x0.floatBad;
                }
            };
        }
        if (type == Type.DOUBLE) {
            if (BadHandler.equalValues(type, badValue, type.defaultBadValue())) {
                return DOUBLE_DEFAULT_HANDLER;
            }
            final double doubleBad = (Double)badValue;
            return new BadHandler(type, badValue){

                public final boolean isBad(Object array, int pos) {
                    double val = ((double[])array)[pos];
                    return val == doubleBad || Double.isNaN(val);
                }

                public final void putBad(Object array, int pos) {
                    ((double[])array)[pos] = doubleBad;
                }

                public final void putBad(Object array, int start, int size) {
                    Arrays.fill((double[])array, start, start + size, doubleBad);
                }

                public final Number makeNumber(Object array, int pos) {
                    double val = ((double[])array)[pos];
                    return val == doubleBad || Double.isNaN(val) ? null : new Double(val);
                }

                public final ArrayHandler arrayHandler(Object arr) {
                    return new ArrayHandler(this, arr){
                        double[] array;
                        private final /* synthetic */ Object val$arr;
                        private final /* synthetic */ 19 this$0;
                        {
                            this.this$0 = this$0;
                            this.val$arr = val$arr;
                            this.array = (double[])this.val$arr;
                        }

                        public boolean isBad(int pos) {
                            double val = this.array[pos];
                            return val == 19.access$400(this.this$0) || Double.isNaN(val);
                        }

                        public void putBad(int pos) {
                            this.array[pos] = 19.access$400(this.this$0);
                        }
                    };
                }

                static /* synthetic */ double access$400(19 x0) {
                    return x0.doubleBad;
                }
            };
        }
        if (type == null) {
            throw new NullPointerException();
        }
        throw new AssertionError((Object)("Unknown type " + type));
    }

    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.getType() == ((BadHandler)other).getType() && BadHandler.equalValues(this.getType(), this.getBadValue(), ((BadHandler)other).getBadValue());
    }

    public int hashCode() {
        return (this.type.toString() + this.badValue.toString()).hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("BadHandler:");
        buf.append(this.type).append(':').append(this.badValue);
        return buf.toString();
    }

    private static boolean equalValues(Type type, Number bad1, Number bad2) {
        if (type == Type.FLOAT) {
            if (bad1 == null) {
                bad1 = type.defaultBadValue();
            }
            if (bad2 == null) {
                bad2 = type.defaultBadValue();
            }
        } else if (type == Type.DOUBLE) {
            if (bad1 == null) {
                bad1 = type.defaultBadValue();
            }
            if (bad2 == null) {
                bad2 = type.defaultBadValue();
            }
        }
        if (bad1 == null && bad2 == null) {
            return true;
        }
        if (bad1 == null || bad2 == null) {
            return false;
        }
        if (bad1.getClass() != bad2.getClass()) {
            return false;
        }
        if (type == Type.BYTE) {
            return ((Byte)bad1).byteValue() == ((Byte)bad2).byteValue();
        }
        if (type == Type.SHORT) {
            return ((Short)bad1).shortValue() == ((Short)bad2).shortValue();
        }
        if (type == Type.INT) {
            return ((Integer)bad1).intValue() == ((Integer)bad2).intValue();
        }
        if (type == Type.FLOAT) {
            return Float.floatToRawIntBits(((Float)bad1).floatValue()) == Float.floatToRawIntBits(((Float)bad2).floatValue());
        }
        if (type == Type.DOUBLE) {
            return Double.doubleToRawLongBits((Double)bad1) == Double.doubleToRawLongBits((Double)bad2);
        }
        throw new AssertionError((Object)("Unknown type " + type));
    }

    private static abstract class NullArrayHandler
    implements ArrayHandler {
        private NullArrayHandler() {
        }

        public final boolean isBad(int pos) {
            return false;
        }

        public abstract void putBad(int var1);
    }

    private static abstract class NullHandler
    extends BadHandler {
        NullHandler(Type type) {
            super(type, null);
        }

        public final boolean isBad(Object array, int pos) {
            return false;
        }
    }

    public static interface ArrayHandler {
        public boolean isBad(int var1);

        public void putBad(int var1);
    }
}

