/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.net.URL;
import org.w3c.dom.Element;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.DefaultArrayAccess;
import uk.ac.starlink.array.DefaultArrayDescription;
import uk.ac.starlink.array.MultiplexArrayAccess;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.hdx.AbstractHdxFacade;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFacade;
import uk.ac.starlink.hdx.HdxResourceType;

public class BridgeNDArray
extends DefaultArrayDescription
implements NDArray {
    private final ArrayImpl impl;
    private final URL url;
    private boolean opened = false;
    private boolean closed = false;
    private AccessImpl soleAccessImpl;
    private Object mappedArray;

    public BridgeNDArray(ArrayImpl impl, URL url) {
        super(impl.getShape(), impl.getType(), BadHandler.getHandler(impl.getType(), impl.getBadValue()), impl.isRandom(), impl.isReadable(), impl.isWritable());
        this.impl = impl;
        this.url = url;
    }

    public BridgeNDArray(ArrayImpl impl) {
        this(impl, null);
    }

    public URL getURL() {
        return this.url;
    }

    public boolean multipleAccess() {
        return this.impl.multipleAccess() || this.impl.isRandom();
    }

    public ArrayAccess getAccess() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("NDArray has been closed");
        }
        if (!this.opened) {
            this.impl.open();
            this.opened = true;
            Object object = this.mappedArray = this.impl.canMap() ? this.impl.getMapped() : null;
            if (!this.impl.multipleAccess()) {
                this.soleAccessImpl = this.impl.getAccess();
            }
        } else if (!this.impl.isRandom() && !this.impl.multipleAccess()) {
            throw new UnsupportedOperationException("Sole ArrayAccess object has already been used.");
        }
        if (this.impl.multipleAccess()) {
            return new DefaultArrayAccess(this, this.impl.getAccess(), this.mappedArray);
        }
        if (this.impl.isRandom()) {
            return new MultiplexArrayAccess(this, this.soleAccessImpl, this.mappedArray);
        }
        return new DefaultArrayAccess(this, this.soleAccessImpl, this.mappedArray);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.impl.close();
            this.mappedArray = null;
            if (this.soleAccessImpl != null && this.impl.isRandom()) {
                this.soleAccessImpl.close();
            }
            this.closed = true;
        }
    }

    public ArrayImpl getImpl() {
        return this.impl;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("BridgeNDArray ");
        buf.append(this.arrayIsReadable ? "r" : "").append(this.arrayIsWritable ? "w" : "").append(' ').append(this.arrayShape).append(' ').append(this.arrayType).append(' ').append(this.arrayHandler).append(' ').append(this.url == null ? "<transient>" : "<" + this.url + ">").append("; impl={ ").append(this.impl.toString()).append(" }");
        return buf.toString();
    }

    public HdxFacade getHdxFacade(HdxResourceType hdxType) {
        return new BridgeNDArrayHdxFacade(hdxType);
    }

    protected class BridgeNDArrayHdxFacade
    extends AbstractHdxFacade {
        private HdxResourceType type;

        public BridgeNDArrayHdxFacade(HdxResourceType type) {
            if (type == null || type == HdxResourceType.NONE) {
                throw new IllegalArgumentException("BridgeNDArrayDOMFacade: type is null or NONE");
            }
            this.type = type;
        }

        public Object synchronizeElement(Element el, Object memento) throws HdxException {
            if (el.hasAttributes()) {
                return null;
            }
            if (!el.getTagName().equals(this.type.xmlName())) {
                throw new HdxException("synchronizeElement given element <" + el.getTagName() + ">, not <" + this.type.xmlName() + "> as expected");
            }
            if (BridgeNDArray.this.url != null) {
                el.setAttribute("uri", BridgeNDArray.this.url.toString());
            }
            return null;
        }

        public Object getObject(Element el) throws HdxException {
            if (this.type != HdxResourceType.match((Element)el)) {
                throw new HdxException("getObject asked to realise bad type " + el.getTagName());
            }
            System.err.println("BridgeNDArrayHdxFacade returning this=" + ((Object)((Object)this)).toString());
            return BridgeNDArray.this;
        }

        public HdxResourceType getHdxResourceType() {
            return this.type;
        }
    }
}

