/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.util.NoSuchElementException;

public class ChunkStepper {
    private long chunkBase = 0L;
    private final long length;
    private final int chunkSize;
    public static int defaultChunkSize = 16384;

    public ChunkStepper(long length, int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize " + chunkSize + " <= 0");
        }
        if (length < 0L) {
            throw new IllegalArgumentException("length " + length + " < 0");
        }
        this.length = length;
        this.chunkSize = chunkSize;
    }

    public ChunkStepper(long length) {
        this(length, defaultChunkSize);
    }

    public boolean hasNext() {
        return this.chunkBase < this.length;
    }

    public int getSize() {
        return (int)Math.min(this.length - this.chunkBase, (long)this.chunkSize);
    }

    public long getBase() {
        return this.chunkBase;
    }

    public void next() {
        if (this.chunkBase < this.length) {
            this.chunkBase += (long)this.getSize();
        } else {
            throw new NoSuchElementException();
        }
    }

    public long getTotalLength() {
        return this.length;
    }
}

