/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.Type;

abstract class ConvertWorker {
    private static final byte MIN_BYTE = -127;
    private static final short MIN_SHORT = -32767;
    private static final int MIN_INT = -2147483647;
    private static final float MIN_FLOAT = -3.4028235E38f;
    private static final double MIN_DOUBLE = -1.7976931348623157E308;
    private static final byte MAX_BYTE = 127;
    private static final short MAX_SHORT = Short.MAX_VALUE;
    private static final int MAX_INT = Integer.MAX_VALUE;
    private static final float MAX_FLOAT = Float.MAX_VALUE;
    private static final double MAX_DOUBLE = Double.MAX_VALUE;

    ConvertWorker() {
    }

    abstract boolean isUnit();

    abstract void convert(Object var1, int var2, Object var3, int var4, int var5);

    static ConvertWorker makeWorker(Type sType, BadHandler sHandler, Type dType, BadHandler dHandler) {
        return ConvertWorker.makeWorker(sType, sHandler, dType, dHandler, null);
    }

    static ConvertWorker makeWorker(Type sType, final BadHandler sHandler, Type dType, BadHandler dHandler, final Mapper mapper) {
        if (sType == Type.BYTE && dType == Type.BYTE && sHandler.equals(dHandler) && mapper == null) {
            return new ConvertWorker(){

                final boolean isUnit() {
                    return true;
                }

                final void convert(Object src, int srcPos, Object dest, int destPos, int length) {
                    System.arraycopy(src, srcPos, dest, destPos, length);
                }
            };
        }
        if (sType == Type.BYTE && dType == Type.BYTE) {
            byte[] destbad = (byte[])Type.BYTE.newArray(1);
            dHandler.putBad(destbad, 0);
            final byte dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        byte[] src = (byte[])source;
                        byte[] dest = (byte[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    byte[] src = (byte[])source;
                    byte[] dest = (byte[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -127.0 || dvald > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.BYTE && dType == Type.SHORT) {
            short[] destbad = (short[])Type.SHORT.newArray(1);
            dHandler.putBad(destbad, 0);
            final short dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        byte[] src = (byte[])source;
                        short[] dest = (short[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (short)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    byte[] src = (byte[])source;
                    short[] dest = (short[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -32767.0 || dvald > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.BYTE && dType == Type.INT) {
            int[] destbad = (int[])Type.INT.newArray(1);
            dHandler.putBad(destbad, 0);
            final int dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        byte[] src = (byte[])source;
                        int[] dest = (int[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    byte[] src = (byte[])source;
                    int[] dest = (int[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -2.147483647E9 || dvald > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.BYTE && dType == Type.FLOAT) {
            float[] destbad = (float[])Type.FLOAT.newArray(1);
            dHandler.putBad(destbad, 0);
            final float dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        byte[] src = (byte[])source;
                        float[] dest = (float[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (float)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    byte[] src = (byte[])source;
                    float[] dest = (float[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -3.4028234663852886E38 || dvald > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.BYTE && dType == Type.DOUBLE) {
            double[] destbad = (double[])Type.DOUBLE.newArray(1);
            dHandler.putBad(destbad, 0);
            final double dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        byte[] src = (byte[])source;
                        double[] dest = (double[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (double)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    byte[] src = (byte[])source;
                    double[] dest = (double[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -1.7976931348623157E308 || dvald > Double.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.SHORT && sHandler.equals(dHandler) && mapper == null) {
            return new ConvertWorker(){

                final boolean isUnit() {
                    return true;
                }

                final void convert(Object src, int srcPos, Object dest, int destPos, int length) {
                    System.arraycopy(src, srcPos, dest, destPos, length);
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.BYTE) {
            byte[] destbad = (byte[])Type.BYTE.newArray(1);
            dHandler.putBad(destbad, 0);
            final byte dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        short[] src = (short[])source;
                        byte[] dest = (byte[])destination;
                        while (length-- > 0) {
                            short sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -127 || sval > 127;
                            dest[destPos] = isBad ? dbad : (byte)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    short[] src = (short[])source;
                    byte[] dest = (byte[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -127.0 || dvald > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.SHORT) {
            short[] destbad = (short[])Type.SHORT.newArray(1);
            dHandler.putBad(destbad, 0);
            final short dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        short[] src = (short[])source;
                        short[] dest = (short[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    short[] src = (short[])source;
                    short[] dest = (short[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -32767.0 || dvald > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.INT) {
            int[] destbad = (int[])Type.INT.newArray(1);
            dHandler.putBad(destbad, 0);
            final int dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        short[] src = (short[])source;
                        int[] dest = (int[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    short[] src = (short[])source;
                    int[] dest = (int[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -2.147483647E9 || dvald > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.FLOAT) {
            float[] destbad = (float[])Type.FLOAT.newArray(1);
            dHandler.putBad(destbad, 0);
            final float dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        short[] src = (short[])source;
                        float[] dest = (float[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (float)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    short[] src = (short[])source;
                    float[] dest = (float[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -3.4028234663852886E38 || dvald > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.SHORT && dType == Type.DOUBLE) {
            double[] destbad = (double[])Type.DOUBLE.newArray(1);
            dHandler.putBad(destbad, 0);
            final double dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        short[] src = (short[])source;
                        double[] dest = (double[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (double)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    short[] src = (short[])source;
                    double[] dest = (double[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -1.7976931348623157E308 || dvald > Double.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.INT && dType == Type.INT && sHandler.equals(dHandler) && mapper == null) {
            return new ConvertWorker(){

                final boolean isUnit() {
                    return true;
                }

                final void convert(Object src, int srcPos, Object dest, int destPos, int length) {
                    System.arraycopy(src, srcPos, dest, destPos, length);
                }
            };
        }
        if (sType == Type.INT && dType == Type.BYTE) {
            byte[] destbad = (byte[])Type.BYTE.newArray(1);
            dHandler.putBad(destbad, 0);
            final byte dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        int[] src = (int[])source;
                        byte[] dest = (byte[])destination;
                        while (length-- > 0) {
                            int sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -127 || sval > 127;
                            dest[destPos] = isBad ? dbad : (byte)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    int[] src = (int[])source;
                    byte[] dest = (byte[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -127.0 || dvald > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.INT && dType == Type.SHORT) {
            short[] destbad = (short[])Type.SHORT.newArray(1);
            dHandler.putBad(destbad, 0);
            final short dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        int[] src = (int[])source;
                        short[] dest = (short[])destination;
                        while (length-- > 0) {
                            int sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -32767 || sval > Short.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : (short)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    int[] src = (int[])source;
                    short[] dest = (short[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -32767.0 || dvald > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.INT && dType == Type.INT) {
            int[] destbad = (int[])Type.INT.newArray(1);
            dHandler.putBad(destbad, 0);
            final int dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        int[] src = (int[])source;
                        int[] dest = (int[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    int[] src = (int[])source;
                    int[] dest = (int[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -2.147483647E9 || dvald > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.INT && dType == Type.FLOAT) {
            float[] destbad = (float[])Type.FLOAT.newArray(1);
            dHandler.putBad(destbad, 0);
            final float dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        int[] src = (int[])source;
                        float[] dest = (float[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (float)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    int[] src = (int[])source;
                    float[] dest = (float[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -3.4028234663852886E38 || dvald > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.INT && dType == Type.DOUBLE) {
            double[] destbad = (double[])Type.DOUBLE.newArray(1);
            dHandler.putBad(destbad, 0);
            final double dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        int[] src = (int[])source;
                        double[] dest = (double[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (double)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    int[] src = (int[])source;
                    double[] dest = (double[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -1.7976931348623157E308 || dvald > Double.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.FLOAT && sHandler.equals(dHandler) && mapper == null) {
            return new ConvertWorker(){

                final boolean isUnit() {
                    return true;
                }

                final void convert(Object src, int srcPos, Object dest, int destPos, int length) {
                    System.arraycopy(src, srcPos, dest, destPos, length);
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.BYTE) {
            byte[] destbad = (byte[])Type.BYTE.newArray(1);
            dHandler.putBad(destbad, 0);
            final byte dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        float[] src = (float[])source;
                        byte[] dest = (byte[])destination;
                        while (length-- > 0) {
                            float sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -127.0f || sval > 127.0f;
                            dest[destPos] = isBad ? dbad : (byte)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    float[] src = (float[])source;
                    byte[] dest = (byte[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -127.0 || dvald > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.SHORT) {
            short[] destbad = (short[])Type.SHORT.newArray(1);
            dHandler.putBad(destbad, 0);
            final short dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        float[] src = (float[])source;
                        short[] dest = (short[])destination;
                        while (length-- > 0) {
                            float sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -32767.0f || sval > 32767.0f;
                            dest[destPos] = isBad ? dbad : (short)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    float[] src = (float[])source;
                    short[] dest = (short[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -32767.0 || dvald > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.INT) {
            int[] destbad = (int[])Type.INT.newArray(1);
            dHandler.putBad(destbad, 0);
            final int dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        float[] src = (float[])source;
                        int[] dest = (int[])destination;
                        while (length-- > 0) {
                            float sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -2.1474836E9f || sval > 2.1474836E9f;
                            dest[destPos] = isBad ? dbad : (int)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    float[] src = (float[])source;
                    int[] dest = (int[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -2.147483647E9 || dvald > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.FLOAT) {
            float[] destbad = (float[])Type.FLOAT.newArray(1);
            dHandler.putBad(destbad, 0);
            final float dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        float[] src = (float[])source;
                        float[] dest = (float[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    float[] src = (float[])source;
                    float[] dest = (float[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -3.4028234663852886E38 || dvald > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.FLOAT && dType == Type.DOUBLE) {
            double[] destbad = (double[])Type.DOUBLE.newArray(1);
            dHandler.putBad(destbad, 0);
            final double dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        float[] src = (float[])source;
                        double[] dest = (double[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : (double)src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    float[] src = (float[])source;
                    double[] dest = (double[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -1.7976931348623157E308 || dvald > Double.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.DOUBLE && sHandler.equals(dHandler) && mapper == null) {
            return new ConvertWorker(){

                final boolean isUnit() {
                    return true;
                }

                final void convert(Object src, int srcPos, Object dest, int destPos, int length) {
                    System.arraycopy(src, srcPos, dest, destPos, length);
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.BYTE) {
            byte[] destbad = (byte[])Type.BYTE.newArray(1);
            dHandler.putBad(destbad, 0);
            final byte dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        double[] src = (double[])source;
                        byte[] dest = (byte[])destination;
                        while (length-- > 0) {
                            double sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -127.0 || sval > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    double[] src = (double[])source;
                    byte[] dest = (byte[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -127.0 || dvald > 127.0;
                            dest[destPos] = isBad ? dbad : (byte)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.SHORT) {
            short[] destbad = (short[])Type.SHORT.newArray(1);
            dHandler.putBad(destbad, 0);
            final short dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        double[] src = (double[])source;
                        short[] dest = (short[])destination;
                        while (length-- > 0) {
                            double sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -32767.0 || sval > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    double[] src = (double[])source;
                    short[] dest = (short[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -32767.0 || dvald > 32767.0;
                            dest[destPos] = isBad ? dbad : (short)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.INT) {
            int[] destbad = (int[])Type.INT.newArray(1);
            dHandler.putBad(destbad, 0);
            final int dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        double[] src = (double[])source;
                        int[] dest = (int[])destination;
                        while (length-- > 0) {
                            double sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -2.147483647E9 || sval > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    double[] src = (double[])source;
                    int[] dest = (int[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -2.147483647E9 || dvald > 2.147483647E9;
                            dest[destPos] = isBad ? dbad : (int)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.FLOAT) {
            float[] destbad = (float[])Type.FLOAT.newArray(1);
            dHandler.putBad(destbad, 0);
            final float dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        double[] src = (double[])source;
                        float[] dest = (float[])destination;
                        while (length-- > 0) {
                            double sval = src[srcPos];
                            boolean isBad = sHandler.isBad(source, srcPos) || sval < -3.4028234663852886E38 || sval > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)sval;
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    double[] src = (double[])source;
                    float[] dest = (float[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -3.4028234663852886E38 || dvald > 3.4028234663852886E38;
                            dest[destPos] = isBad ? dbad : (float)dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        if (sType == Type.DOUBLE && dType == Type.DOUBLE) {
            double[] destbad = (double[])Type.DOUBLE.newArray(1);
            dHandler.putBad(destbad, 0);
            final double dbad = destbad[0];
            if (mapper == null) {
                return new NonunitConvertWorker(dHandler){

                    final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                        double[] src = (double[])source;
                        double[] dest = (double[])destination;
                        while (length-- > 0) {
                            boolean isBad = sHandler.isBad(source, srcPos);
                            dest[destPos] = isBad ? dbad : src[srcPos];
                            ++destPos;
                            ++srcPos;
                        }
                    }
                };
            }
            return new NonunitConvertWorker(dHandler){

                final void convert(Object source, int srcPos, Object destination, int destPos, int length) {
                    double[] src = (double[])source;
                    double[] dest = (double[])destination;
                    while (length-- > 0) {
                        if (sHandler.isBad(source, srcPos)) {
                            dest[destPos] = dbad;
                        } else {
                            double dvald = mapper.func(src[srcPos]);
                            boolean isBad = Double.isNaN(dvald) || dvald < -1.7976931348623157E308 || dvald > Double.MAX_VALUE;
                            dest[destPos] = isBad ? dbad : dvald;
                        }
                        ++destPos;
                        ++srcPos;
                    }
                }
            };
        }
        return null;
    }

    static interface Mapper {
        public double func(double var1);
    }

    private static abstract class NonunitConvertWorker
    extends ConvertWorker {
        private final BadHandler destHandler;

        NonunitConvertWorker(BadHandler destHandler) {
            this.destHandler = destHandler;
        }

        final boolean isUnit() {
            return false;
        }
    }
}

