/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.ConvertArrayImpl;
import uk.ac.starlink.array.CopyNDArray;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.OffsetMapper;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.OrderedShapeMapper;
import uk.ac.starlink.array.PixelMapArrayImpl;
import uk.ac.starlink.array.ReorderingMapper;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.ScratchNDArray;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.TypeConverter;
import uk.ac.starlink.array.WindowArrayImpl;

public class NDArrays {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$array$NDArrays;

    private NDArrays() {
    }

    public static void copy(NDArray src, NDArray dest) throws IOException {
        NDArrays.checkSameShape(src, dest);
        NDArrays.checkSameType(src, dest);
        NDArrays.checkReadable(src);
        NDArrays.checkWritable(dest);
        NDArrays.copy(src.getAccess(), dest.getAccess());
    }

    public static boolean equals(NDArray nda1, NDArray nda2) throws IOException {
        Requirements req;
        ArrayAccess acc2;
        ArrayAccess acc1;
        OrderedNDShape oshape2;
        Type type = nda1.getType();
        if (nda2.getType() != type) {
            return false;
        }
        OrderedNDShape oshape1 = nda1.getShape();
        if (!oshape1.sameShape(oshape2 = nda2.getShape())) {
            return false;
        }
        long npix = oshape1.getNumPixels();
        Order order1 = oshape1.getOrder();
        Order order2 = oshape2.getOrder();
        NDArray ndatmp = null;
        if (order1 == order2) {
            acc1 = nda1.getAccess();
            acc2 = nda2.getAccess();
        } else if (nda1.isRandom()) {
            req = new Requirements().setOrder(order2);
            ndatmp = NDArrays.toRequiredArray(nda1, req);
            acc1 = ndatmp.getAccess();
            acc2 = nda2.getAccess();
        } else {
            req = new Requirements().setOrder(order1);
            ndatmp = NDArrays.toRequiredArray(nda2, req);
            acc1 = nda1.getAccess();
            acc2 = ndatmp.getAccess();
        }
        ChunkStepper cit = new ChunkStepper(npix);
        int size = cit.getSize();
        Object buf1 = type.newArray(size);
        Object buf2 = type.newArray(size);
        BadHandler bh1 = nda1.getBadHandler();
        BadHandler bh2 = nda2.getBadHandler();
        boolean match = true;
        while (cit.hasNext() && match) {
            boolean bad2;
            boolean bad1;
            int i;
            Object[] b2;
            Object[] b1;
            size = cit.getSize();
            acc1.read(buf1, 0, size);
            acc2.read(buf2, 0, size);
            if (type == Type.BYTE) {
                b1 = (byte[])buf1;
                b2 = (byte[])buf2;
                i = 0;
                while (i < size) {
                    bad1 = bh1.isBad(b1, i);
                    bad2 = bh2.isBad(b2, i);
                    match = match && (!bad1 && !bad2 && b1[i] == b2[i] || bad1 && bad2);
                    ++i;
                }
            } else if (type == Type.SHORT) {
                b1 = (short[])buf1;
                b2 = (short[])buf2;
                i = 0;
                while (i < size) {
                    bad1 = bh1.isBad(b1, i);
                    bad2 = bh2.isBad(b2, i);
                    match = match && (!bad1 && !bad2 && b1[i] == b2[i] || bad1 && bad2);
                    ++i;
                }
            } else if (type == Type.INT) {
                b1 = (int[])buf1;
                b2 = (int[])buf2;
                i = 0;
                while (i < size) {
                    bad1 = bh1.isBad(b1, i);
                    bad2 = bh2.isBad(b2, i);
                    match = match && (!bad1 && !bad2 && b1[i] == b2[i] || bad1 && bad2);
                    ++i;
                }
            } else if (type == Type.FLOAT) {
                b1 = (float[])buf1;
                b2 = (float[])buf2;
                i = 0;
                while (i < size) {
                    bad1 = bh1.isBad(b1, i);
                    bad2 = bh2.isBad(b2, i);
                    match = match && (!bad1 && !bad2 && b1[i] == b2[i] || bad1 && bad2);
                    ++i;
                }
            } else if (type == Type.DOUBLE) {
                b1 = (double[])buf1;
                b2 = (double[])buf2;
                i = 0;
                while (i < size) {
                    bad1 = bh1.isBad(b1, i);
                    bad2 = bh2.isBad(b2, i);
                    match = match && (!bad1 && !bad2 && b1[i] == b2[i] || bad1 && bad2);
                    ++i;
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            cit.next();
        }
        acc1.close();
        acc2.close();
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(ArrayAccess sAccess, ArrayAccess dAccess) throws IOException {
        OrderedNDShape shape = sAccess.getShape();
        long npix = shape.getNumPixels();
        Type sType = sAccess.getType();
        Type dType = dAccess.getType();
        TypeConverter conv = new TypeConverter(sType, sAccess.getBadHandler(), dType, dAccess.getBadHandler());
        try {
            if (sAccess.getShape().sameSequence(dAccess.getShape())) {
                if (sAccess.isMapped() && dAccess.isMapped()) {
                    conv.convert12(sAccess.getMapped(), 0, dAccess.getMapped(), 0, (int)npix);
                } else if (sAccess.isMapped() && conv.isUnit12()) {
                    dAccess.write(sAccess.getMapped(), 0, (int)npix);
                } else if (dAccess.isMapped() && conv.isUnit12()) {
                    sAccess.read(dAccess.getMapped(), 0, (int)npix);
                } else {
                    ChunkStepper cIt = new ChunkStepper(npix);
                    int size = cIt.getSize();
                    Object sBuffer = sType.newArray(size);
                    Object dBuffer = dType.newArray(size);
                    while (cIt.hasNext()) {
                        size = cIt.getSize();
                        sAccess.read(sBuffer, 0, size);
                        conv.convert12(sBuffer, 0, dBuffer, 0, size);
                        dAccess.write(dBuffer, 0, size);
                        cIt.next();
                    }
                }
            } else if (sAccess.isRandom()) {
                Object sBuffer1 = sType.newArray(1);
                Object dBuffer1 = dType.newArray(1);
                Iterator pIt = dAccess.getShape().pixelIterator();
                while (pIt.hasNext()) {
                    sAccess.setPosition((long[])pIt.next());
                    sAccess.read(sBuffer1, 0, 1);
                    conv.convert12(sBuffer1, 0, dBuffer1, 0, 1);
                    dAccess.write(dBuffer1, 0, 1);
                }
            } else if (dAccess.isRandom()) {
                Object sBuffer1 = sType.newArray(1);
                Object dBuffer1 = dType.newArray(1);
                Iterator pIt = sAccess.getShape().pixelIterator();
                while (pIt.hasNext()) {
                    dAccess.setPosition((long[])pIt.next());
                    sAccess.read(sBuffer1, 0, 1);
                    conv.convert12(sBuffer1, 0, dBuffer1, 0, 1);
                    dAccess.write(dBuffer1, 0, 1);
                }
            } else {
                ScratchNDArray scratch = new ScratchNDArray(sAccess);
                try {
                    NDArrays.copy(sAccess, scratch.getAccess());
                    NDArrays.copy(scratch.getAccess(), dAccess);
                    Object var13_18 = null;
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    scratch.close();
                    throw throwable;
                }
                scratch.close();
                {
                }
            }
            Object var15_21 = null;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            sAccess.close();
            dAccess.close();
            throw throwable;
        }
        sAccess.close();
        dAccess.close();
    }

    public static NDArray toRequiredArray(NDArray nda, Requirements req) throws IOException {
        if (req == null) {
            return nda;
        }
        Type type = req.getType();
        NDShape window = req.getWindow();
        Order order = req.getOrder();
        BadHandler badHandler = req.getBadHandler();
        boolean random = req.getRandom();
        AccessMode mode = req.getMode();
        if (mode == null) {
            mode = nda.isReadable() && nda.isWritable() ? AccessMode.UPDATE : (nda.isWritable() ? AccessMode.WRITE : AccessMode.READ);
        }
        if (type != null && type != nda.getType() || badHandler != null && badHandler.getBadValue() != nda.getBadHandler().getBadValue()) {
            if (badHandler == null) {
                badHandler = type.defaultBadHandler();
            }
            TypeConverter conv = new TypeConverter(nda.getType(), nda.getBadHandler(), type, badHandler);
            nda = new BridgeNDArray(new ConvertArrayImpl(nda, conv));
        }
        if ((random || order != null && order != nda.getShape().getOrder()) && !nda.isRandom()) {
            nda = new CopyNDArray(nda, mode);
        }
        if (order != null && order != nda.getShape().getOrder()) {
            if (!$assertionsDisabled && !nda.isRandom()) {
                throw new AssertionError();
            }
            if (window == null) {
                window = new NDShape(nda.getShape());
            }
            OrderedNDShape oshape = new OrderedNDShape(window, order);
            OffsetMapper mapper = window.sameShape(nda.getShape()) ? new ReorderingMapper(window, order, nda.getShape().getOrder()) : new OrderedShapeMapper(oshape, nda.getShape());
            nda = new BridgeNDArray(new PixelMapArrayImpl(nda, oshape, mapper));
        } else if (window != null && !window.sameShape(nda.getShape())) {
            nda = new BridgeNDArray(new WindowArrayImpl(nda, window));
        }
        return nda;
    }

    public static NDArray scratchCopy(NDArray nda) throws IOException {
        ScratchNDArray copy = new ScratchNDArray(nda);
        NDArrays.copy(nda, copy);
        return copy;
    }

    public static NDArray scratchCopy(ArrayImpl impl) throws IOException {
        return NDArrays.scratchCopy(new BridgeNDArray(impl));
    }

    private static void checkReadable(NDArray nda) {
        if (!nda.isReadable()) {
            throw new UnsupportedOperationException(nda + " is not readable");
        }
    }

    private static void checkWritable(NDArray nda) {
        if (!nda.isWritable()) {
            throw new UnsupportedOperationException(nda + " is not writable");
        }
    }

    private static void checkSameShape(NDArray nda1, NDArray nda2) {
        if (!nda1.getShape().sameShape(nda2.getShape())) {
            throw new IllegalArgumentException(nda1 + " and " + nda2 + " have different shapes");
        }
    }

    private static void checkSameType(NDArray nda1, NDArray nda2) {
        if (nda1.getType() != nda2.getType()) {
            throw new IllegalArgumentException(nda1 + " and " + nda2 + " have different types");
        }
    }

    private static void checkMode(NDArray nda, AccessMode mode) {
        if (mode.isReadable() && !nda.isReadable()) {
            throw new IllegalArgumentException("Read mode requested on unreadable base NDArray " + nda);
        }
        if (mode.isWritable() && !nda.isWritable()) {
            throw new IllegalArgumentException("Write mode requested on unwritable base NDArray " + nda);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$array$NDArrays == null ? (class$uk$ac$starlink$array$NDArrays = NDArrays.class$("uk.ac.starlink.array.NDArrays")) : class$uk$ac$starlink$array$NDArrays).desiredAssertionStatus();
    }
}

