/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.Buffer;
import uk.ac.starlink.array.AccessImpl;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.util.GenericNioBuffer;

public class NioArrayImpl
implements ArrayImpl {
    private final BufferGetter bufget;
    private final OrderedNDShape oshape;
    private final Type type;
    private final Number badValue;
    private final boolean isWritable;
    private Object mappedArray;
    private Buffer nioBuf;
    private GenericNioBuffer genBuf;

    public NioArrayImpl(BufferGetter bufget, OrderedNDShape oshape, Type type, Number badval) {
        this.bufget = bufget;
        this.oshape = oshape;
        this.type = type;
        this.badValue = badval;
        this.isWritable = !bufget.isReadOnly();
    }

    public NioArrayImpl(final Buffer buf, OrderedNDShape oshape, Type type, Number badval) {
        this(new BufferGetter(){

            public boolean isReadOnly() {
                return buf.isReadOnly();
            }

            public Buffer getBuffer() {
                return buf;
            }

            public void releaseBuffer() {
            }
        }, oshape, type, badval);
    }

    public void open() throws IOException {
        this.nioBuf = new GenericNioBuffer(this.bufget.getBuffer()).duplicate().rewind();
        this.genBuf = new GenericNioBuffer(this.nioBuf);
        if (this.genBuf.getElementClass() != this.type.javaClass()) {
            throw new IOException("Supplied buffer is of type " + this.genBuf.getElementClass() + " not declared type " + this.type.javaClass());
        }
        this.mappedArray = this.genBuf.hasArray() && this.genBuf.arrayOffset() == 0 && this.nioBuf.capacity() == Array.getLength(this.genBuf.array()) ? this.genBuf.array() : null;
    }

    public boolean canMap() {
        return this.mappedArray != null;
    }

    public Object getMapped() {
        return this.mappedArray;
    }

    public void close() throws IOException {
        if (this.nioBuf != null) {
            this.bufget.releaseBuffer();
        }
        this.mappedArray = null;
        this.nioBuf = null;
        this.genBuf = null;
    }

    public OrderedNDShape getShape() {
        return this.oshape;
    }

    public Type getType() {
        return this.type;
    }

    public Number getBadValue() {
        return this.badValue;
    }

    public boolean isRandom() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean multipleAccess() {
        return true;
    }

    public AccessImpl getAccess() {
        final Buffer acNioBuf = this.genBuf.duplicate();
        final GenericNioBuffer acGenBuf = new GenericNioBuffer(acNioBuf);
        return new AccessImpl(){

            public void setOffset(long off) {
                acNioBuf.position((int)off);
            }

            public void read(Object buffer, int start, int size) {
                acGenBuf.get(buffer, start, size);
            }

            public void write(Object buffer, int start, int size) {
                acGenBuf.put(buffer, start, size);
            }

            public void close() {
            }
        };
    }

    public static interface BufferGetter {
        public boolean isReadOnly();

        public Buffer getBuffer() throws IOException;

        public void releaseBuffer() throws IOException;
    }
}

