/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.array;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import uk.ac.starlink.array.ArrayDescription;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.NioArrayImpl;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;

public class ScratchNDArray
extends BridgeNDArray {
    public ScratchNDArray(ArrayDescription template) {
        this(template.getShape(), template.getType(), template.getBadHandler());
    }

    public ScratchNDArray(OrderedNDShape shape, Type type, BadHandler badHandler) {
        this(shape, type, badHandler, ScratchNDArray.getDefaultBackingStore(shape.getNumPixels() * (long)type.getNumBytes()));
    }

    public ScratchNDArray(OrderedNDShape shape, Type type, BadHandler badHandler, BackingStore bstore) {
        super(new NioArrayImpl(ScratchNDArray.getNioBuffer(type, shape.getNumPixels(), bstore), shape, type, badHandler.getBadValue()));
    }

    private static BackingStore getDefaultBackingStore(long nbytes) {
        if (nbytes < (long)ScratchNDArray.directAllocationThreshold()) {
            return BackingStore.MEMORY;
        }
        if (nbytes < Integer.MAX_VALUE) {
            return BackingStore.DIRECT;
        }
        throw new UnsupportedOperationException("Buffers longer than 2147483647 not yet supported");
    }

    private static Buffer getNioBuffer(Type type, long npix, BackingStore bstore) {
        if (bstore == BackingStore.MEMORY) {
            Object array = type.newArray((int)npix);
            if (type == Type.BYTE) {
                return ByteBuffer.wrap((byte[])array);
            }
            if (type == Type.SHORT) {
                return ShortBuffer.wrap((short[])array);
            }
            if (type == Type.INT) {
                return IntBuffer.wrap((int[])array);
            }
            if (type == Type.FLOAT) {
                return FloatBuffer.wrap((float[])array);
            }
            if (type == Type.DOUBLE) {
                return DoubleBuffer.wrap((double[])array);
            }
            throw new AssertionError();
        }
        if (bstore == BackingStore.DIRECT) {
            long nbyte = npix * (long)type.getNumBytes();
            if (nbyte > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Too many bytes " + nbyte + " for direct allocation");
            }
            ByteBuffer byteBuf = ByteBuffer.allocateDirect((int)nbyte);
            byteBuf.order(ByteOrder.nativeOrder());
            if (type == Type.BYTE) {
                return byteBuf;
            }
            if (type == Type.SHORT) {
                return byteBuf.asShortBuffer();
            }
            if (type == Type.INT) {
                return byteBuf.asIntBuffer();
            }
            if (type == Type.FLOAT) {
                return byteBuf.asFloatBuffer();
            }
            if (type == Type.DOUBLE) {
                return byteBuf.asDoubleBuffer();
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    private static int directAllocationThreshold() {
        return (int)Math.min(Math.max(Runtime.getRuntime().totalMemory() / 64L, 0x100000L), Integer.MAX_VALUE);
    }

    public static class BackingStore {
        private String name;
        public static final BackingStore MEMORY = new BackingStore("MEMORY");
        public static final BackingStore DIRECT = new BackingStore("DIRECT");

        private BackingStore(String name) {
            this.name = name;
        }
    }
}

