/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.common.ivorn;

import java.net.URI;
import java.net.URISyntaxException;
import org.astrogrid.store.Ivorn;

public class MockIvorn
extends Ivorn {
    public static final String MOCK_IDENT = "org.astrogrid.mock";

    public MockIvorn(String ident) throws URISyntaxException {
        super(MockIvorn.createIdent(ident));
    }

    public MockIvorn(String ident, String path) throws URISyntaxException {
        super(MockIvorn.createIdent(ident, path));
    }

    protected MockIvorn(String ident, String path, String fragment) throws URISyntaxException {
        super(MockIvorn.createIdent(ident, path, fragment));
    }

    protected static String createIdent(String ident) {
        return MockIvorn.createIdent(ident, null, null, null);
    }

    protected static String createIdent(String ident, String path) {
        return MockIvorn.createIdent(ident, path, null, null);
    }

    protected static String createIdent(String ident, String path, String fragment) {
        return MockIvorn.createIdent(ident, path, null, fragment);
    }

    protected static String createIdent(String ident, String path, String query, String fragment) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ivo");
        buffer.append("://");
        if (null != ident) {
            if (ident.length() > 0) {
                if (!ident.startsWith(MOCK_IDENT)) {
                    buffer.append(MOCK_IDENT);
                    buffer.append(".");
                }
                buffer.append(ident);
            } else {
                buffer.append(MOCK_IDENT);
            }
        } else {
            buffer.append(MOCK_IDENT);
        }
        if (null != path) {
            buffer.append("/");
            buffer.append(path);
        }
        if (null != query) {
            buffer.append("?");
            buffer.append(query);
        }
        if (null != fragment) {
            buffer.append("#");
            buffer.append(fragment);
        }
        return buffer.toString();
    }

    public static boolean isMock(Ivorn ivorn) {
        return MockIvorn.isMock(ivorn.toString());
    }

    public static boolean isMock(String string) {
        try {
            return MockIvorn.isMock(new URI(string));
        }
        catch (URISyntaxException ouch) {
            return false;
        }
    }

    public static boolean isMock(URI uri) {
        return null != uri.getHost() ? uri.getHost().startsWith(MOCK_IDENT) : false;
    }
}

