/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.config;

import java.io.File;
import java.net.InetAddress;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.handler.URLHandler;
import org.jconfig.handler.XMLFileHandler;

public class CommunityConfig {
    private static Log log = LogFactory.getLog((Class)CommunityConfig.class);
    public static final String CONFIG_NAME = "org.astrogrid.community";
    public static final String DEFAULT_CATEGORY = "org.astrogrid.community";
    public static final String DEFAULT_JNDI_NAME = "org.astrogrid.community.config";
    public static final String DEFAULT_PROPERTY_NAME = "org.astrogrid.community.config";
    public static final String LOCALHOST_PROPERTY_NAME = "community.host";
    public static final String COMMUNITY_PROPERTY_NAME = "community.name";
    public static final String POLICY_MANAGER_PROPERTY_NAME = "policy.manager.url";
    public static final String POLICY_SERVICE_PROPERTY_NAME = "policy.service.url";
    public static final String AUTHENTICATOR_PROPERTY_NAME = "authentication.service.url";
    private static Configuration config = null;
    private static String localhost = null;
    private static String community = null;
    private static String manager = null;
    private static String service = null;
    private static String authenticator = null;
    private static String admin = null;
    public static final String ASTROGRID_ADMIN_PROPERTY_NAME = "astrogrid.admin";
    private static String adminEmail = null;
    public static final String ASTROGRID_ADMIN_EMAIL_PROPERTY_NAME = "astrogrid.adminEmail";

    public static String getJndiProperty(String name) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityConfig.getJndiProperty()");
        String value = null;
        try {
            log.debug((Object)"  JNDI name  : org.astrogrid.community.config");
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            value = (String)envCtx.lookup("org.astrogrid.community.config");
            log.debug((Object)("  JNDI value : " + value));
        }
        catch (Exception ouch) {
            log.debug((Object)"Exception while trying JNDI lookup");
            value = null;
        }
        log.debug((Object)"----\"----");
        log.debug((Object)"");
        return value;
    }

    public static Configuration loadConfig() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityConfig.loadConfig()");
        if (null == config) {
            String path = null;
            if (null == path) {
                log.debug((Object)"Trying JNDI property");
                path = CommunityConfig.getJndiProperty("org.astrogrid.community.config");
                if (null != path) {
                    log.debug((Object)"PASS : Got JNDI property");
                }
            }
            if (null == path) {
                log.debug((Object)"Trying system property");
                path = System.getProperty("org.astrogrid.community.config");
                if (null != path) {
                    log.debug((Object)"PASS : Got system property");
                }
            }
            if (null == path) {
                log.debug((Object)"FAIL : Unable to get config file path");
            }
            if (null != path) {
                CommunityConfig.loadConfig(path);
            }
        }
        log.debug((Object)"----\"----");
        log.debug((Object)"");
        return config;
    }

    public static Configuration loadConfig(String path) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityConfig.loadConfig()");
        log.debug((Object)("  Path  : " + path));
        if (null == config && null != path) {
            ConfigurationManager manager = ConfigurationManager.getInstance();
            try {
                if (null != path) {
                    if (path.startsWith("http")) {
                        URLHandler handler = new URLHandler();
                        handler.setURL(path);
                        manager.load((ConfigurationHandler)handler, "org.astrogrid.community");
                    } else {
                        File file = new File(path);
                        XMLFileHandler handler = new XMLFileHandler();
                        handler.setFile(file);
                        handler.load(file);
                        manager.load((ConfigurationHandler)handler, "org.astrogrid.community");
                    }
                    config = ConfigurationManager.getConfiguration((String)"org.astrogrid.community");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                config = null;
            }
            if (null != config) {
                config.setProperty("config.location", path);
                log.debug((Object)"  ----");
                String[] names = config.getPropertyNames("org.astrogrid.community");
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    String value = config.getProperty(name, "", "org.astrogrid.community");
                    log.debug((Object)("  '" + name + "' : '" + value + "'"));
                }
                log.debug((Object)"  ----");
            }
        }
        log.debug((Object)"----\"----");
        log.debug((Object)"");
        return config;
    }

    public static String getProperty(String propName) {
        return CommunityConfig.getProperty(propName, null, "org.astrogrid.community");
    }

    public static String getProperty(String propName, String defaultVal) {
        return CommunityConfig.getProperty(propName, defaultVal, "org.astrogrid.community");
    }

    public static String getProperty(String propName, String defaultVal, String category) {
        if (null == config) {
            config = ConfigurationManager.getConfiguration((String)"org.astrogrid.community");
        }
        return null != config ? config.getProperty(propName, defaultVal, category) : null;
    }

    public static String getHostName() {
        if (null == localhost || localhost.length() <= 0) {
            log.debug((Object)"getHostName()");
            log.debug((Object)"  Trying config property 'community.host'");
            localhost = CommunityConfig.getProperty(LOCALHOST_PROPERTY_NAME);
            log.debug((Object)("  Config property result : " + localhost));
        }
        if (null == localhost || localhost.length() <= 0) {
            String name = "org.astrogrid.community.community.host";
            log.debug((Object)"getHostName()");
            log.debug((Object)("  Trying system property '" + name + "'"));
            localhost = System.getProperty(name);
            log.debug((Object)("  System property result : " + localhost));
        }
        if (null == localhost || localhost.length() <= 0) {
            log.debug((Object)"getHostName()");
            log.debug((Object)"  Trying localhost ....");
            try {
                localhost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ouch) {
                localhost = "localhost";
            }
            log.debug((Object)("  Localhost result : " + localhost));
        }
        return localhost;
    }

    public static String getCommunityName() {
        if (null == community || community.length() <= 0) {
            log.debug((Object)"getCommunityName()");
            log.debug((Object)"  Trying config property 'community.name'");
            community = CommunityConfig.getProperty(COMMUNITY_PROPERTY_NAME);
            log.debug((Object)("  Config property result : " + community));
        }
        if (null == community || community.length() <= 0) {
            String name = "org.astrogrid.community.community.name";
            log.debug((Object)"getCommunityName()");
            log.debug((Object)("  Trying system property '" + name + "'"));
            community = System.getProperty(name);
            log.debug((Object)("  System property result : " + community));
        }
        if (null == community || community.length() <= 0) {
            log.debug((Object)"getCommunityName()");
            log.debug((Object)"  Trying localhost ....");
            community = CommunityConfig.getHostName();
            log.debug((Object)("  Localhost result : " + community));
        }
        return community;
    }

    public static String getManagerUrl() {
        log.debug((Object)"getManagerUrl()");
        if (null == manager || manager.length() <= 0) {
            log.debug((Object)"getManagerUrl()");
            log.debug((Object)"  Trying config property 'policy.manager.url'");
            manager = CommunityConfig.getProperty(POLICY_MANAGER_PROPERTY_NAME);
            if (null != manager) {
                manager = manager.trim();
            }
            log.debug((Object)("  Config property result : " + manager));
        }
        if (null == manager || manager.length() <= 0) {
            log.debug((Object)"getManagerUrl()");
            log.debug((Object)"  Trying localhost ....");
            manager = "http://" + CommunityConfig.getHostName() + ":8080/axis/services/PolicyManager";
            log.debug((Object)("  Localhost result : " + manager));
        }
        log.debug((Object)("  Manager URL : " + manager));
        return manager;
    }

    public static String getServiceUrl() {
        log.debug((Object)"getServiceUrl()");
        if (null == service || service.length() <= 0) {
            log.debug((Object)"getServiceUrl()");
            log.debug((Object)"  Trying config property 'policy.service.url'");
            service = CommunityConfig.getProperty(POLICY_SERVICE_PROPERTY_NAME);
            if (null != service) {
                service = service.trim();
            }
            log.debug((Object)("  Config property result : " + service));
        }
        if (null == service || service.length() <= 0) {
            log.debug((Object)"getServiceUrl()");
            log.debug((Object)"  Trying localhost ....");
            service = "http://" + CommunityConfig.getHostName() + ":8080/axis/services/PolicyService";
            log.debug((Object)("  Localhost result : " + service));
        }
        log.debug((Object)("  Service URL : " + service));
        return service;
    }

    public static String getAuthenticationServiceUrl() {
        log.debug((Object)"getAuthenticationServiceUrl()");
        if (null == authenticator || authenticator.length() <= 0) {
            log.debug((Object)"getAuthenticationServiceUrl()");
            log.debug((Object)"  Trying config property 'authentication.service.url'");
            authenticator = CommunityConfig.getProperty(AUTHENTICATOR_PROPERTY_NAME);
            if (null != authenticator) {
                authenticator = authenticator.trim();
            }
            log.debug((Object)("  Config property result : " + authenticator));
        }
        if (null == authenticator || authenticator.length() <= 0) {
            log.debug((Object)"getAuthenticationServiceUrl()");
            log.debug((Object)"  Trying localhost ....");
            authenticator = "http://" + CommunityConfig.getHostName() + ":8080/axis/services/AuthenticationService";
            log.debug((Object)("  Localhost result : " + authenticator));
        }
        log.debug((Object)("  Authenticator URL : " + authenticator));
        return authenticator;
    }

    public static String getAdministrator() {
        if (null == admin) {
            admin = CommunityConfig.getProperty(ASTROGRID_ADMIN_PROPERTY_NAME);
        }
        return admin;
    }

    public static String getAdministratorEmail() {
        if (null == adminEmail) {
            adminEmail = CommunityConfig.getProperty(ASTROGRID_ADMIN_EMAIL_PROPERTY_NAME);
        }
        return adminEmail;
    }
}

