/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.ivorn;

import java.net.URISyntaxException;
import org.astrogrid.common.ivorn.MockIvorn;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityIvornFactory;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.store.Ivorn;

public class CommunityAccountIvornFactory
extends CommunityIvornFactory {
    public static Ivorn createLocal(String account) throws CommunityServiceException, CommunityIdentifierException {
        return CommunityAccountIvornFactory.createIvorn(CommunityIvornParser.getLocalIdent(), account);
    }

    public static Ivorn createLocal(String account, String resource) throws CommunityServiceException, CommunityIdentifierException {
        return CommunityAccountIvornFactory.createIvorn(CommunityIvornParser.getLocalIdent(), account, resource);
    }

    public static Ivorn createIvorn(String community, String account) throws CommunityIdentifierException {
        try {
            return new Ivorn(CommunityAccountIvornFactory.createIdent(community, account));
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }

    public static Ivorn createIvorn(String community, String account, String resource) throws CommunityIdentifierException {
        try {
            return new Ivorn(CommunityAccountIvornFactory.createIdent(community, account, resource));
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }

    public static Ivorn createMock(String community, String account) throws CommunityIdentifierException {
        try {
            return new MockIvorn(community, account);
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }
}

