/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.ivorn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;

public class CommunityIvornFactory {
    private static Log log = LogFactory.getLog((Class)CommunityIvornFactory.class);

    protected static String createIdent(String community, String resource) throws CommunityIdentifierException {
        return CommunityIvornFactory.createIdent(community, resource, null, null, null);
    }

    protected static String createIdent(String community, String resource, String path) throws CommunityIdentifierException {
        return CommunityIvornFactory.createIdent(community, resource, path, null, null);
    }

    protected static String createIdent(String community, String resource, String path, String fragment) throws CommunityIdentifierException {
        return CommunityIvornFactory.createIdent(community, resource, path, null, fragment);
    }

    protected static String createIdent(String community, String resource, String path, String query, String fragment) throws CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornFactory.createIdent()");
        log.debug((Object)("  Community : " + community));
        log.debug((Object)("  Resource  : " + resource));
        log.debug((Object)("  Path      : " + path));
        log.debug((Object)("  Query     : " + query));
        log.debug((Object)("  Fragment  : " + fragment));
        if (null == community) {
            throw new CommunityIdentifierException("Null Community identifier");
        }
        if (null == resource) {
            throw new CommunityIdentifierException("Null Resource identifier");
        }
        StringBuffer buffer = new StringBuffer();
        if (!community.startsWith("ivo")) {
            buffer.append("ivo");
            buffer.append("://");
        }
        buffer.append(community);
        buffer.append("/");
        buffer.append(resource);
        if (null != path) {
            buffer.append("/");
            buffer.append(path);
        }
        if (null != query) {
            buffer.append("?");
            buffer.append(query);
        }
        if (null != fragment) {
            buffer.append("#");
            buffer.append(fragment);
        }
        log.debug((Object)("  Result    : " + buffer.toString()));
        return buffer.toString();
    }
}

