/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.ivorn;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.common.ivorn.MockIvorn;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityAccountIvornFactory;
import org.astrogrid.config.Config;
import org.astrogrid.config.PropertyNotFoundException;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.store.Ivorn;

public class CommunityIvornParser {
    private static Log log = LogFactory.getLog((Class)CommunityIvornParser.class);
    protected static Config config = SimpleConfig.getSingleton();
    private Ivorn ivorn;
    private URI uri;
    private String community;
    private String account;
    private String path;
    private String query;
    private String fragment;
    private static Pattern pattern;
    public static final String LOCAL_COMMUNITY_PROPERTY = "org.astrogrid.community.ident";

    public CommunityIvornParser(Ivorn ivorn) throws CommunityIdentifierException {
        this.setIvorn(ivorn);
    }

    public CommunityIvornParser(String ident) throws CommunityIdentifierException {
        this.setIvorn(CommunityIvornParser.parse(ident));
    }

    public Ivorn getIvorn() {
        return this.ivorn;
    }

    protected void setIvorn(Ivorn ivorn) throws CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.setIvorn()");
        log.debug((Object)("  Ivorn : " + ivorn));
        if (null == ivorn) {
            throw new CommunityIdentifierException("Null identifier");
        }
        this.ivorn = ivorn;
        this.uri = null;
        this.account = null;
        this.community = null;
        this.path = null;
        this.fragment = null;
        try {
            this.uri = new URI(ivorn.toString());
            this.parseCommunityIdent();
            this.parseAccountIdent();
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }

    protected void parseCommunityIdent() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.parseCommunityIdent()");
        log.debug((Object)("  Ivorn     : " + this.ivorn));
        if (null != this.uri) {
            this.community = this.uri.getHost();
        }
        log.debug((Object)("  Community : " + this.community));
    }

    public String getCommunityName() {
        return this.community;
    }

    public String getCommunityIdent() {
        return "ivo" + "://" + this.community;
    }

    public Ivorn getCommunityIvorn() {
        if (null != this.getCommunityIdent()) {
            return new Ivorn(this.getCommunityName(), null);
        }
        return null;
    }

    protected void parseAccountIdent() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.parseAccountIdent()");
        log.debug((Object)("  Ivorn : " + this.ivorn));
        this.account = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
        if (null != this.uri) {
            this.account = this.uri.getUserInfo();
            if (null != this.account) {
                if (null != this.uri.getPath() && this.uri.getPath().length() > 0) {
                    if (this.uri.getPath().startsWith("/")) {
                        if (this.uri.getPath().length() > 1) {
                            this.path = this.uri.getPath().substring(1);
                        }
                    } else {
                        this.path = this.uri.getPath();
                    }
                }
                if (null != this.uri.getFragment() && this.uri.getFragment().length() > 0) {
                    this.fragment = this.uri.getFragment();
                }
            } else if (null != this.uri.getPath()) {
                this.parseAccountPath();
            } else {
                this.parseAccountFragment();
            }
            if (null != this.uri.getQuery() && this.uri.getQuery().length() > 0) {
                this.query = this.uri.getQuery();
            }
        }
        log.debug((Object)(" Account   : " + this.account));
        log.debug((Object)(" Path      : " + this.path));
        log.debug((Object)(" Query     : " + this.query));
        log.debug((Object)(" Fragment  : " + this.fragment));
    }

    protected void parseAccountPath() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.parseAccountPath()");
        log.debug((Object)("  Ivorn : " + this.ivorn));
        log.debug((Object)("  Path  : " + this.uri.getPath()));
        if (null != this.uri.getPath()) {
            Matcher matcher = pattern.matcher(this.uri.getPath());
            if (matcher.matches()) {
                String temp;
                if (matcher.groupCount() > 0) {
                    this.account = matcher.group(1);
                }
                if (matcher.groupCount() > 1 && (temp = matcher.group(2).trim()).length() > 0) {
                    this.path = temp;
                }
                this.fragment = this.uri.getFragment();
            } else {
                this.parseAccountFragment();
            }
        }
    }

    protected void parseAccountFragment() {
        Matcher matcher;
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.parseAccountFragment()");
        log.debug((Object)("  Ivorn    : " + this.ivorn));
        log.debug((Object)("  Fragment : " + this.uri.getFragment()));
        if (null != this.uri.getFragment() && (matcher = pattern.matcher(this.uri.getFragment())).matches()) {
            String temp;
            if (matcher.groupCount() > 0) {
                this.account = matcher.group(1);
            }
            if (matcher.groupCount() > 1 && (temp = matcher.group(2).trim()).length() > 0) {
                this.fragment = temp;
            }
        }
    }

    public String getAccountName() {
        return this.account;
    }

    public String getAccountIdent() {
        if (null != this.getCommunityIdent() && null != this.getAccountName()) {
            return this.getCommunityIdent() + "/" + this.getAccountName();
        }
        return null;
    }

    public Ivorn getAccountIvorn() throws CommunityIdentifierException {
        if (null != this.getCommunityIdent() && null != this.getAccountName()) {
            return CommunityAccountIvornFactory.createIvorn(this.getCommunityName(), this.getAccountName());
        }
        return null;
    }

    protected String getPath() {
        return this.path;
    }

    protected String getQuery() {
        return this.query;
    }

    protected String getFragment() {
        return this.fragment;
    }

    public String getRemainder() {
        StringBuffer buffer = new StringBuffer();
        if (null != this.path) {
            buffer.append("/");
            buffer.append(this.path);
        }
        if (null != this.query) {
            buffer.append("?");
            buffer.append(this.query);
        }
        if (null != this.fragment) {
            buffer.append("#");
            buffer.append(this.fragment);
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    public boolean isMock() {
        return MockIvorn.isMock(this.ivorn);
    }

    protected static Ivorn parse(String ident) throws CommunityIdentifierException {
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        try {
            return new Ivorn(ident);
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }

    public static String getLocalIdent() throws CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.getLocalIdent()");
        try {
            String local = (String)config.getProperty(LOCAL_COMMUNITY_PROPERTY);
            log.debug((Object)("  Local : " + local));
            if (null != local) {
                return local;
            }
            throw new CommunityServiceException("Local Community identifier not configured");
        }
        catch (PropertyNotFoundException ouch) {
            throw new CommunityServiceException("Local Community identifier not configured");
        }
    }

    public boolean isLocal() throws CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityIvornParser.isLocal()");
        log.debug((Object)("  Ivorn : " + this.ivorn));
        return CommunityIvornParser.getLocalIdent().equals(this.getCommunityName());
    }

    public String toString() {
        return "CommunityIvornParser : " + (null != this.ivorn ? this.ivorn.toString() : null);
    }

    static {
        try {
            pattern = Pattern.compile("^/?([^/]+)/?(.*)");
        }
        catch (Exception ouch) {
            log.debug((Object)"ERROR ----");
            log.debug((Object)"CommunityIvornParser RegExp pattern is not valid.");
            log.debug((Object)ouch);
            log.debug((Object)"----------");
        }
    }
}

