/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.ivorn;

import java.net.URISyntaxException;
import org.astrogrid.common.ivorn.MockIvorn;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.ivorn.CommunityIvornFactory;
import org.astrogrid.store.Ivorn;

public class CommunityServiceIvornFactory
extends CommunityIvornFactory {
    public static Ivorn createIvorn(String community, Class service) throws CommunityIdentifierException {
        if (null == community) {
            throw new CommunityIdentifierException("Null Community identifier");
        }
        if (null == service) {
            throw new CommunityIdentifierException("Null service type");
        }
        try {
            return new Ivorn(CommunityServiceIvornFactory.createIdent(community, service.getName()));
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }

    public static Ivorn createMock(String community, Class service) throws CommunityIdentifierException {
        if (null == community) {
            throw new CommunityIdentifierException("Null Community identifier");
        }
        if (null == service) {
            throw new CommunityIdentifierException("Null service type");
        }
        try {
            return new MockIvorn(CommunityServiceIvornFactory.createIdent(community, service.getName()));
        }
        catch (URISyntaxException ouch) {
            throw new CommunityIdentifierException(ouch);
        }
    }
}

