/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.data;

import org.astrogrid.community.common.config.CommunityConfig;

public class CommunityIdent {
    public static String DEFAULT_ACCOUNT = "nobody";
    public static char IDENT_SEPARATOR = (char)64;
    private boolean valid = false;
    private boolean local = false;
    private String ident;
    private String name;
    private String community;

    public CommunityIdent(String ident) {
        if (null == ident || 0 == ident.length()) {
            ident = DEFAULT_ACCOUNT;
        }
        this.ident = ident = ident.toLowerCase();
        int first = ident.indexOf(IDENT_SEPARATOR);
        int last = ident.lastIndexOf(IDENT_SEPARATOR);
        if (-1 != first) {
            if (first == last) {
                this.name = ident.substring(0, first);
                this.community = ident.substring(first + 1);
                if (CommunityConfig.getCommunityName().equals(this.community)) {
                    this.valid = true;
                    this.local = true;
                } else {
                    this.valid = true;
                    this.local = false;
                }
            } else {
                this.valid = false;
                this.local = false;
                this.name = null;
                this.community = null;
            }
        } else {
            this.name = ident;
            this.community = CommunityConfig.getCommunityName();
            this.ident = this.name + IDENT_SEPARATOR + this.community;
            this.valid = true;
            this.local = true;
        }
    }

    public CommunityIdent(String name, String community) {
        this(name + IDENT_SEPARATOR + community);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getName() {
        return this.name;
    }

    public String getCommunity() {
        return this.community;
    }

    public String toString() {
        return this.ident;
    }
}

