/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.data;

public class PolicyPermission {
    public static final int STATUS_PERMISSION_GRANTED = 255;
    public static final int STATUS_PERMISSION_UNKNOWN = 0;
    public static final int STATUS_PERMISSION_REVOKED = 1;
    public static final int STATUS_CREDENTIALS_INVALID = 2;
    public static final String XML_PERMISSION_GRANTED = "GRANT";
    public static final String XML_PERMISSION_UNKNOWN = "UNKNOWN";
    public static final String XML_PERMISSION_REVOKED = "REVOKED";
    public static final String XML_CREDENTIALS_INVALID = "INVALID";
    public static final String REASON_PERMISSION_UNKNOWN = "Permissions unknown";
    public static final String REASON_NO_PERMISSION = "No permissions set";
    public static final String REASON_CREDENTIALS_INVALID = "Credentials invalid";
    private String group;
    private String resource;
    private String action;
    private int status;
    private String reason;

    public PolicyPermission() {
    }

    public PolicyPermission(String resource, String group, String action) {
        this.group = group;
        this.action = action;
        this.resource = resource;
        this.status = 0;
        this.reason = REASON_PERMISSION_UNKNOWN;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String value) {
        this.group = value;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String value) {
        this.resource = value;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String value) {
        this.action = value;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public void setStatus(String value) {
        this.setStatus(0);
        if (XML_PERMISSION_GRANTED.equals(value)) {
            this.setStatus(255);
        }
        if (XML_PERMISSION_UNKNOWN.equals(value)) {
            this.setStatus(0);
        }
        if (XML_PERMISSION_REVOKED.equals(value)) {
            this.setStatus(1);
        }
        if (XML_CREDENTIALS_INVALID.equals(value)) {
            this.setStatus(2);
        }
    }

    public boolean isValid() {
        return 255 == this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String value) {
        this.reason = value;
    }
}

