/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.manager.AccountManager;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class AccountManagerMock
extends CommunityServiceMock
implements AccountManager {
    private static Log log = LogFactory.getLog((Class)AccountManagerMock.class);
    private static Map map = new HashMap();

    public AccountManagerMock() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock()");
    }

    public static void reset() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.reset()");
        map.clear();
    }

    public AccountData addAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.addAccount()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (map.containsKey(ident)) {
            throw new CommunityPolicyException("Duplicate account", ident);
        }
        AccountData account = new AccountData(ident);
        map.put(account.getIdent(), account);
        return account;
    }

    public AccountData addAccount(AccountData account) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.addAccount()");
        log.debug((Object)("  Account : " + (null != account ? account.getIdent() : null)));
        if (null == account) {
            throw new CommunityIdentifierException("Null account");
        }
        if (null == account.getIdent()) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (map.containsKey(account.getIdent())) {
            throw new CommunityPolicyException("Duplicate account", account.getIdent());
        }
        map.put(account.getIdent(), account);
        return account;
    }

    public AccountData getAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.getAccount()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        AccountData account = (AccountData)map.get(ident);
        if (null != account) {
            return account;
        }
        throw new CommunityPolicyException("Account not found", ident);
    }

    public AccountData setAccount(AccountData update) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.setAccount()");
        log.debug((Object)("  Ident : " + (null != update ? update.getIdent() : null)));
        if (null == update) {
            throw new CommunityIdentifierException("Null inout data");
        }
        if (null == update.getIdent()) {
            throw new CommunityIdentifierException("Null inout data");
        }
        AccountData found = this.getAccount(update.getIdent());
        map.put(found.getIdent(), update);
        return update;
    }

    public AccountData delAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.delAccount()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        AccountData account = this.getAccount(ident);
        if (null != account) {
            map.remove(account.getIdent());
            return account;
        }
        throw new CommunityPolicyException("Account not found", ident);
    }

    public Object[] getLocalAccounts() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerMock.getLocalAccounts()");
        return map.values().toArray();
    }
}

