/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.manager.AccountManager;
import org.astrogrid.community.common.service.CommunityServiceTest;

public class AccountManagerTest
extends CommunityServiceTest {
    private static Log log = LogFactory.getLog((Class)AccountManagerTest.class);
    private AccountManager accountManager;

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public void setAccountManager(AccountManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest.setAccountManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.accountManager = manager;
        this.setCommunityService(manager);
    }

    public void testCreateNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testCreateNull()");
        try {
            this.accountManager.addAccount((String)null);
            AccountManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        try {
            this.accountManager.addAccount((AccountData)null);
            AccountManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testCreateValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testCreateValid()");
        AccountManagerTest.assertNotNull((String)"Null account", (Object)this.accountManager.addAccount(this.createLocal("test-account").toString()));
    }

    public void testCreateData() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testCreateData()");
        AccountManagerTest.assertNotNull((String)"Null account", (Object)this.accountManager.addAccount(new AccountData(this.createLocal("test-account").toString())));
    }

    public void testCreateDuplicate() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testCreateDuplicate()");
        AccountManagerTest.assertNotNull((String)"Null account", (Object)this.accountManager.addAccount(this.createLocal("test-account").toString()));
        try {
            this.accountManager.addAccount(this.createLocal("test-account").toString());
            AccountManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testGetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testGetNull()");
        try {
            this.accountManager.getAccount(null);
            AccountManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testGetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testGetUnknown()");
        try {
            this.accountManager.getAccount(this.createLocal("unknown-account").toString());
            AccountManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testGetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testGetValid()");
        AccountData created = this.accountManager.addAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)created);
        AccountData found = this.accountManager.getAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)found);
        AccountManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)found);
    }

    public void testSetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testSetNull()");
        try {
            this.accountManager.setAccount(null);
            AccountManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testSetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testSetUnknown()");
        try {
            this.accountManager.setAccount(new AccountData(this.createLocal("unknown-account").toString()));
            AccountManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testSetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testSetValid()");
        AccountData account = this.accountManager.addAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)account);
        account.setDisplayName("Test DisplayName");
        account.setDescription("Test Description");
        account.setEmailAddress("Test EmailAddress");
        account.setHomeSpace("Test HomeSpace");
        account = this.accountManager.setAccount(account);
        AccountManagerTest.assertNotNull((String)"Null account", (Object)account);
        AccountManagerTest.assertEquals((String)"Different details", (String)"Test DisplayName", (String)account.getDisplayName());
        AccountManagerTest.assertEquals((String)"Different details", (String)"Test Description", (String)account.getDescription());
        AccountManagerTest.assertEquals((String)"Different details", (String)"Test EmailAddress", (String)account.getEmailAddress());
        AccountManagerTest.assertEquals((String)"Different details", (String)"Test HomeSpace", (String)account.getHomeSpace());
        account = this.accountManager.getAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)account);
        AccountManagerTest.assertEquals((String)"Different details", (String)account.getDisplayName(), (String)"Test DisplayName");
        AccountManagerTest.assertEquals((String)"Different details", (String)account.getDescription(), (String)"Test Description");
        AccountManagerTest.assertEquals((String)"Different details", (String)account.getEmailAddress(), (String)"Test EmailAddress");
        AccountManagerTest.assertEquals((String)"Different details", (String)account.getHomeSpace(), (String)"Test HomeSpace");
    }

    public void testDeleteNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testDeleteNull()");
        try {
            this.accountManager.delAccount(null);
            AccountManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testDeleteUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testDeleteUnknown()");
        try {
            this.accountManager.delAccount(this.createLocal("unknown-account").toString());
            AccountManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testDeleteValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testDeleteValid()");
        AccountData created = this.accountManager.addAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)created);
        AccountData deleted = this.accountManager.delAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)deleted);
        AccountManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
    }

    public void testDeleteTwice() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"AccountManagerTest:testDeleteTwice()");
        AccountData created = this.accountManager.addAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)created);
        AccountData deleted = this.accountManager.delAccount(this.createLocal("test-account").toString());
        AccountManagerTest.assertNotNull((String)"Null account", (Object)deleted);
        AccountManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
        try {
            this.accountManager.delAccount(this.createLocal("test-account").toString());
            AccountManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }
}

