/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.CommunityData;
import org.astrogrid.community.common.policy.manager.CommunityManager;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class CommunityManagerMock
extends CommunityServiceMock
implements CommunityManager {
    private static Log log = LogFactory.getLog((Class)CommunityManagerMock.class);
    private Map map = new HashMap();

    public CommunityData addCommunity(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerMock.addCommunity()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (this.map.containsKey(ident)) {
            throw new CommunityPolicyException("Duplicate account", ident);
        }
        CommunityData community = new CommunityData(ident);
        this.map.put(community.getIdent(), community);
        return community;
    }

    public CommunityData getCommunity(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerMock.getCommunity()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        CommunityData community = (CommunityData)this.map.get(ident);
        if (null != community) {
            return community;
        }
        throw new CommunityPolicyException("Community not found", ident);
    }

    public CommunityData setCommunity(CommunityData update) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerMock.setCommunity()");
        log.debug((Object)("  Ident : " + (null != update ? update.getIdent() : null)));
        if (null == update) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (null == update.getIdent()) {
            throw new CommunityIdentifierException("Null identifier");
        }
        CommunityData found = this.getCommunity(update.getIdent());
        this.map.put(found.getIdent(), update);
        return update;
    }

    public CommunityData delCommunity(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerMock.delCommunity()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        CommunityData community = this.getCommunity(ident);
        this.map.remove(community.getIdent());
        return community;
    }

    public Object[] getCommunityList() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerMock.getCommunityList()");
        return this.map.values().toArray();
    }
}

