/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.CommunityData;
import org.astrogrid.community.common.policy.manager.CommunityManager;
import org.astrogrid.community.common.service.CommunityServiceTest;

public class CommunityManagerTest
extends CommunityServiceTest {
    private static Log log = LogFactory.getLog((Class)CommunityManagerTest.class);
    private CommunityManager communityManager;

    public CommunityManager getCommunityManager() {
        return this.communityManager;
    }

    public void setCommunityManager(CommunityManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest.setCommunityManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.communityManager = manager;
        this.setCommunityService(manager);
    }

    public void testCreateNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testCreateNull()");
        try {
            this.communityManager.addCommunity(null);
            CommunityManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testCreateValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testCreateValid()");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)this.communityManager.addCommunity("test-community"));
    }

    public void testCreateDuplicate() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testCreateDuplicate()");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)this.communityManager.addCommunity("test-community"));
        try {
            this.communityManager.addCommunity("test-community");
            CommunityManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testGetNull()");
        try {
            this.communityManager.getCommunity(null);
            CommunityManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testGetUnknown()");
        try {
            this.communityManager.getCommunity("unknown-community");
            CommunityManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testGetValid()");
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testCreateValid()");
        CommunityData created = this.communityManager.addCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)created);
        CommunityData found = this.communityManager.getCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)found);
        CommunityManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)found);
    }

    public void testSetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testSetNull()");
        try {
            this.communityManager.setCommunity(null);
            CommunityManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testSetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testSetUnknown()");
        try {
            this.communityManager.setCommunity(new CommunityData("unknown-community"));
            CommunityManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testSetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testSetValid()");
        CommunityData community = this.communityManager.addCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)community);
        community.setDescription("Test Description");
        community = this.communityManager.setCommunity(community);
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)community);
        CommunityManagerTest.assertEquals((String)"Different details", (String)"Test Description", (String)community.getDescription());
        community = this.communityManager.getCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)community);
        CommunityManagerTest.assertEquals((String)"Different details", (String)community.getDescription(), (String)"Test Description");
    }

    public void testDeleteNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testDeleteNull()");
        try {
            this.communityManager.delCommunity(null);
            CommunityManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testDeleteUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testDeleteUnknown()");
        try {
            this.communityManager.delCommunity("unknown-community");
            CommunityManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testDeleteValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testDeleteValid()");
        CommunityData created = this.communityManager.addCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)created);
        CommunityData deleted = this.communityManager.delCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)deleted);
        CommunityManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
    }

    public void testDeleteTwice() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityManagerTest:testDeleteTwice()");
        CommunityData created = this.communityManager.addCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)created);
        CommunityData deleted = this.communityManager.delCommunity("test-community");
        CommunityManagerTest.assertNotNull((String)"Null community", (Object)deleted);
        CommunityManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
        try {
            this.communityManager.delCommunity("test-community");
            CommunityManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }
}

