/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.GroupData;
import org.astrogrid.community.common.policy.manager.GroupManager;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class GroupManagerMock
extends CommunityServiceMock
implements GroupManager {
    private static Log log = LogFactory.getLog((Class)GroupManagerMock.class);
    private static Map map = new HashMap();

    public static void reset() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.reset()");
        map.clear();
    }

    public GroupData addGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.addGroup()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (map.containsKey(ident)) {
            throw new CommunityPolicyException("Duplicate group", ident);
        }
        GroupData group = new GroupData(ident);
        map.put(group.getIdent(), group);
        return group;
    }

    public GroupData addGroup(GroupData group) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.addGroup()");
        log.debug((Object)("  Group : " + (null != group ? group.getIdent() : null)));
        if (null == group) {
            throw new CommunityIdentifierException("Null group");
        }
        if (null == group.getIdent()) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (map.containsKey(group.getIdent())) {
            throw new CommunityPolicyException("Duplicate group", group.getIdent());
        }
        map.put(group.getIdent(), group);
        return group;
    }

    public GroupData getGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.getGroup()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        GroupData group = (GroupData)map.get(ident);
        if (null != group) {
            return group;
        }
        throw new CommunityPolicyException("Group not found", ident);
    }

    public GroupData setGroup(GroupData update) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.setGroup()");
        log.debug((Object)("  Ident : " + (null != update ? update.getIdent() : null)));
        if (null == update) {
            throw new CommunityIdentifierException("Null inout data");
        }
        if (null == update.getIdent()) {
            throw new CommunityIdentifierException("Null inout data");
        }
        GroupData found = this.getGroup(update.getIdent());
        map.put(found.getIdent(), update);
        return update;
    }

    public GroupData delGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.delGroup()");
        log.debug((Object)("  Ident : " + ident));
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        GroupData group = this.getGroup(ident);
        if (null != group) {
            map.remove(group.getIdent());
            return group;
        }
        throw new CommunityPolicyException("Group not found", ident);
    }

    public Object[] getLocalGroups() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.getLocalGroups()");
        return map.values().toArray();
    }

    public Object[] getLocalAccountGroups(String account) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerMock.getAccountGroups()");
        return map.values().toArray();
    }
}

