/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.policy.data.GroupData;
import org.astrogrid.community.common.policy.manager.GroupManager;
import org.astrogrid.community.common.service.CommunityServiceTest;

public class GroupManagerTest
extends CommunityServiceTest {
    private static Log log = LogFactory.getLog((Class)GroupManagerTest.class);
    private GroupManager groupManager;

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest.setGroupManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.groupManager = manager;
        this.setCommunityService(manager);
    }

    public void testCreateNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testCreateNull()");
        try {
            this.groupManager.addGroup((String)null);
            GroupManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
        try {
            this.groupManager.addGroup((GroupData)null);
            GroupManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testCreateValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testCreateValid()");
        GroupManagerTest.assertNotNull((String)"Null group", (Object)this.groupManager.addGroup(this.createLocal("test-group").toString()));
    }

    public void testCreateData() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testCreateData()");
        GroupManagerTest.assertNotNull((String)"Null group", (Object)this.groupManager.addGroup(new GroupData(this.createLocal("test-group").toString())));
    }

    public void testCreateDuplicate() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testCreateDuplicate()");
        GroupManagerTest.assertNotNull((String)"Null group", (Object)this.groupManager.addGroup(this.createLocal("test-group").toString()));
        try {
            this.groupManager.addGroup(this.createLocal("test-group").toString());
            GroupManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testGetNull()");
        try {
            this.groupManager.getGroup(null);
            GroupManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testGetUnknown()");
        try {
            this.groupManager.getGroup(this.createLocal("unknown-group").toString());
            GroupManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testGetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testGetValid()");
        GroupData created = this.groupManager.addGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)created);
        GroupData found = this.groupManager.getGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)found);
        GroupManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)found);
    }

    public void testSetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testSetNull()");
        try {
            this.groupManager.setGroup(null);
            GroupManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testSetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testSetUnknown()");
        try {
            this.groupManager.setGroup(new GroupData(this.createLocal("unknown-group").toString()));
            GroupManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testSetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testSetValid()");
        GroupData group = this.groupManager.addGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)group);
        group.setDisplayName("Test DisplayName");
        group.setDescription("Test Description");
        group = this.groupManager.setGroup(group);
        GroupManagerTest.assertNotNull((String)"Null group", (Object)group);
        GroupManagerTest.assertEquals((String)"Different details", (String)"Test DisplayName", (String)group.getDisplayName());
        GroupManagerTest.assertEquals((String)"Different details", (String)"Test Description", (String)group.getDescription());
        group = this.groupManager.getGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)group);
        GroupManagerTest.assertEquals((String)"Different details", (String)"Test DisplayName", (String)group.getDisplayName());
        GroupManagerTest.assertEquals((String)"Different details", (String)"Test Description", (String)group.getDescription());
    }

    public void testDeleteNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testDeleteNull()");
        try {
            this.groupManager.delGroup(null);
            GroupManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testDeleteUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testDeleteUnknown()");
        try {
            this.groupManager.delGroup(this.createLocal("unknown-group").toString());
            GroupManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }

    public void testDeleteValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testDeleteValid()");
        GroupData created = this.groupManager.addGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)created);
        GroupData deleted = this.groupManager.delGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)deleted);
        GroupManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
    }

    public void testDeleteTwice() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"GroupManagerTest:testDeleteTwice()");
        GroupData created = this.groupManager.addGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)created);
        GroupData deleted = this.groupManager.delGroup(this.createLocal("test-group").toString());
        GroupManagerTest.assertNotNull((String)"Null group", (Object)deleted);
        GroupManagerTest.assertEquals((String)"Different identifiers", (Object)created, (Object)deleted);
        try {
            this.groupManager.delGroup(this.createLocal("test-group").toString());
            GroupManagerTest.fail((String)"Expected CommunityPolicyException");
        }
        catch (CommunityPolicyException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
    }
}

