/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.policy.data.PolicyPermission;
import org.astrogrid.community.common.policy.manager.PermissionManager;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class PermissionManagerMock
extends CommunityServiceMock
implements PermissionManager {
    private static Log log = LogFactory.getLog((Class)PermissionManagerMock.class);
    private Map map = new HashMap();

    protected String getHashKey(String resource, String group, String action) {
        return group + "," + action + "," + resource;
    }

    protected String getHashKey(PolicyPermission data) {
        return this.getHashKey(data.getGroup(), data.getAction(), data.getResource());
    }

    public PolicyPermission addPermission(String resource, String group, String action) {
        String ident = this.getHashKey(resource, group, action);
        if (null != this.getPermission(ident)) {
            return null;
        }
        PolicyPermission permission = new PolicyPermission(resource, group, action);
        this.map.put(ident, permission);
        return permission;
    }

    protected PolicyPermission getPermission(String ident) {
        return (PolicyPermission)this.map.get(ident);
    }

    public PolicyPermission getPermission(String resource, String group, String action) {
        return this.getPermission(this.getHashKey(resource, group, action));
    }

    public PolicyPermission setPermission(PolicyPermission permission) {
        String ident = this.getHashKey(permission);
        if (null == this.getPermission(ident)) {
            return null;
        }
        this.map.put(ident, permission);
        return permission;
    }

    public boolean delPermission(String resource, String group, String action) {
        String ident = this.getHashKey(resource, group, action);
        PolicyPermission permission = this.getPermission(ident);
        if (null == permission) {
            return false;
        }
        this.map.remove(ident);
        return true;
    }
}

