/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.exception.CommunityResourceException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.data.GroupData;
import org.astrogrid.community.common.policy.data.GroupMemberData;
import org.astrogrid.community.common.policy.data.PolicyPermission;
import org.astrogrid.community.common.policy.data.ResourceData;
import org.astrogrid.community.common.policy.manager.AccountManagerMock;
import org.astrogrid.community.common.policy.manager.GroupManagerMock;
import org.astrogrid.community.common.policy.manager.PermissionManagerMock;
import org.astrogrid.community.common.policy.manager.PolicyManager;
import org.astrogrid.community.common.policy.manager.ResourceManagerMock;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class PolicyManagerMock
extends CommunityServiceMock
implements PolicyManager {
    private static Log log = LogFactory.getLog((Class)PolicyManagerMock.class);
    private AccountManagerMock accountManager = new AccountManagerMock();
    private GroupManagerMock groupManager = new GroupManagerMock();
    private ResourceManagerMock resourceManager = new ResourceManagerMock();
    private PermissionManagerMock permissionManager = new PermissionManagerMock();

    public PolicyManagerMock() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyManagerMock()");
    }

    public AccountData addAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.accountManager.addAccount(ident);
    }

    public AccountData addAccount(AccountData account) throws CommunityIdentifierException, CommunityPolicyException {
        return this.accountManager.addAccount(account);
    }

    public AccountData getAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.accountManager.getAccount(ident);
    }

    public AccountData setAccount(AccountData update) throws CommunityIdentifierException, CommunityPolicyException {
        return this.accountManager.setAccount(update);
    }

    public AccountData delAccount(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.accountManager.delAccount(ident);
    }

    public Object[] getLocalAccounts() {
        return this.accountManager.getLocalAccounts();
    }

    public GroupData addGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.groupManager.addGroup(ident);
    }

    public GroupData addGroup(GroupData group) throws CommunityIdentifierException, CommunityPolicyException {
        return this.groupManager.addGroup(group);
    }

    public GroupData getGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.groupManager.getGroup(ident);
    }

    public GroupData setGroup(GroupData update) throws CommunityIdentifierException, CommunityPolicyException {
        return this.groupManager.setGroup(update);
    }

    public GroupData delGroup(String ident) throws CommunityIdentifierException, CommunityPolicyException {
        return this.groupManager.delGroup(ident);
    }

    public Object[] getLocalGroups() {
        return this.groupManager.getLocalGroups();
    }

    public Object[] getLocalAccountGroups(String account) {
        return this.groupManager.getLocalAccountGroups(account);
    }

    public ResourceData addResource() throws CommunityServiceException {
        return this.resourceManager.addResource();
    }

    public ResourceData getResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        return this.resourceManager.getResource(ident);
    }

    public ResourceData setResource(ResourceData resource) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        return this.resourceManager.setResource(resource);
    }

    public ResourceData delResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        return this.resourceManager.delResource(ident);
    }

    public PolicyPermission addPermission(String resource, String group, String action) throws RemoteException {
        return this.permissionManager.addPermission(resource, group, action);
    }

    public PolicyPermission getPermission(String resource, String group, String action) throws RemoteException {
        return this.permissionManager.getPermission(resource, group, action);
    }

    public PolicyPermission setPermission(PolicyPermission permission) throws RemoteException {
        return this.permissionManager.setPermission(permission);
    }

    public boolean delPermission(String resource, String group, String action) throws RemoteException {
        return this.permissionManager.delPermission(resource, group, action);
    }

    public Object[] getRemoteAccounts(String community) {
        return null;
    }

    public Object[] getRemoteGroups(String community) {
        return null;
    }

    public GroupMemberData addGroupMember(String account, String group) {
        return null;
    }

    public GroupMemberData delGroupMember(String account, String group) {
        return null;
    }

    public Object[] getGroupMembers(String group) {
        return null;
    }
}

