/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityResourceException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.identifier.ResourceIdentifier;
import org.astrogrid.community.common.policy.data.ResourceData;
import org.astrogrid.community.common.policy.manager.ResourceManager;
import org.astrogrid.community.common.service.CommunityServiceMock;

public class ResourceManagerMock
extends CommunityServiceMock
implements ResourceManager {
    private static Log log = LogFactory.getLog((Class)ResourceManagerMock.class);
    public static boolean SERVICE_EXCEPTIONS = false;
    private static Map map = new HashMap();

    public static void reset() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerMock.reset()");
        map.clear();
    }

    public ResourceData addResource() throws CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerMock.addResource()");
        if (SERVICE_EXCEPTIONS) {
            throw new CommunityServiceException("Mock exception test");
        }
        ResourceData resource = new ResourceData(new ResourceIdentifier());
        map.put(resource.getIdent(), resource);
        return resource;
    }

    public ResourceData getResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerMock.getResource()");
        log.debug((Object)("  Ident : " + ident));
        if (SERVICE_EXCEPTIONS) {
            throw new CommunityServiceException("Mock exception test");
        }
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        ResourceData resource = (ResourceData)map.get(ident);
        if (null != resource) {
            return resource;
        }
        throw new CommunityResourceException("Unable to locate resource", ident);
    }

    public ResourceData setResource(ResourceData resource) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerMock.setResource()");
        log.debug((Object)("  Resource : " + resource));
        if (SERVICE_EXCEPTIONS) {
            throw new CommunityServiceException("Mock exception test");
        }
        if (null == resource) {
            throw new CommunityResourceException("Null resource");
        }
        if (null == resource.getIdent()) {
            throw new CommunityIdentifierException("Null identifier");
        }
        if (map.containsKey(resource.getIdent())) {
            map.put(resource.getIdent(), resource);
            return resource;
        }
        throw new CommunityResourceException("Unable to locate resource", resource.getIdent());
    }

    public ResourceData delResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerMock.delResource()");
        log.debug((Object)("  Ident : " + ident));
        if (SERVICE_EXCEPTIONS) {
            throw new CommunityServiceException("Mock exception test");
        }
        if (null == ident) {
            throw new CommunityIdentifierException("Null identifier");
        }
        ResourceData original = (ResourceData)map.get(ident);
        if (null != original) {
            map.remove(ident);
            return original;
        }
        throw new CommunityResourceException("Unable to locate resource", ident);
    }
}

