/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.policy.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityResourceException;
import org.astrogrid.community.common.policy.data.ResourceData;
import org.astrogrid.community.common.policy.manager.ResourceManager;
import org.astrogrid.community.common.service.CommunityServiceTest;

public class ResourceManagerTest
extends CommunityServiceTest {
    private static Log log = LogFactory.getLog((Class)ResourceManagerTest.class);
    private ResourceManager resourceManager;

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest.setResourceManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.resourceManager = manager;
        this.setCommunityService(manager);
    }

    public void testRegisterValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testRegisterValid()");
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)this.resourceManager.addResource());
    }

    public void testGetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testGetValid()");
        ResourceData created = this.resourceManager.addResource();
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)created);
        String ident = created.getIdent();
        ResourceManagerTest.assertNotNull((String)"Null resource ident", (Object)ident);
        ResourceData found = this.resourceManager.getResource(ident);
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)found);
        ResourceManagerTest.assertEquals((String)"Identifiers don't match", (String)created.getIdent(), (String)found.getIdent());
    }

    public void testGetUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testGetUnknown()");
        try {
            this.resourceManager.getResource("unknown");
            ResourceManagerTest.fail((String)"Expected CommunityResourceException");
        }
        catch (CommunityResourceException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testGetNullIdent() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testGetNullIdent()");
        try {
            this.resourceManager.getResource(null);
            ResourceManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testSetValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testSetValid()");
        ResourceData created = this.resourceManager.addResource();
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)created);
        String ident = created.getIdent();
        ResourceManagerTest.assertNotNull((String)"Null resource ident", (Object)ident);
        String description = "Test description";
        created.setDescription(description);
        ResourceData modified = this.resourceManager.setResource(created);
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)modified);
        ResourceManagerTest.assertEquals((String)"Descriptions don't match", (String)description, (String)modified.getDescription());
        ResourceData found = this.resourceManager.getResource(ident);
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)found);
        ResourceManagerTest.assertEquals((String)"Descriptions don't match", (String)description, (String)found.getDescription());
    }

    public void testSetNull() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testSetNull()");
        try {
            this.resourceManager.setResource(null);
            ResourceManagerTest.fail((String)"Expected CommunityResourceException");
        }
        catch (CommunityResourceException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testSetNullIdent() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testSetNullIdent()");
        try {
            this.resourceManager.setResource(new ResourceData());
            ResourceManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testSetUnknownIdent() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testSetUnknownIdent()");
        try {
            this.resourceManager.setResource(new ResourceData("unknown"));
            ResourceManagerTest.fail((String)"Expected CommunityResourceException");
        }
        catch (CommunityResourceException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testDelValid() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testDelValid()");
        ResourceData created = this.resourceManager.addResource();
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)created);
        String ident = created.getIdent();
        ResourceManagerTest.assertNotNull((String)"Null resource ident", (Object)ident);
        ResourceData found = this.resourceManager.getResource(ident);
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)found);
        ResourceData deleted = this.resourceManager.delResource(ident);
        ResourceManagerTest.assertNotNull((String)"Null resource", (Object)deleted);
        try {
            this.resourceManager.getResource(ident);
            ResourceManagerTest.fail((String)"Expected CommunityResourceException");
        }
        catch (CommunityResourceException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testDelUnknown() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testDelUnknown()");
        try {
            this.resourceManager.delResource("unknown");
            ResourceManagerTest.fail((String)"Expected CommunityResourceException");
        }
        catch (CommunityResourceException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }

    public void testDelNullIdent() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"ResourceManagerTest:testDelNullIdent()");
        try {
            this.resourceManager.delResource(null);
            ResourceManagerTest.fail((String)"Expected CommunityIdentifierException");
        }
        catch (CommunityIdentifierException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
    }
}

