/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.security.service;

import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.ivorn.CommunityAccountIvornFactory;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.common.security.service.SecurityService;
import org.astrogrid.community.common.service.CommunityServiceMock;
import org.astrogrid.store.Ivorn;

public class SecurityServiceMock
extends CommunityServiceMock
implements SecurityService {
    private static Log log = LogFactory.getLog((Class)SecurityServiceMock.class);
    private static String secret = null;
    protected static Map map = new HashMap();

    public SecurityServiceMock() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceMock()");
    }

    public static String getPassword() {
        return secret;
    }

    public static void setPassword(String value) {
        secret = value;
    }

    protected SecurityToken createToken(String ident) throws CommunityIdentifierException {
        CommunityIvornParser ivorn = new CommunityIvornParser(ident);
        log.debug((Object)("  Ivorn : " + ivorn));
        return this.createToken(ivorn);
    }

    protected SecurityToken createToken(CommunityIvornParser account) throws CommunityIdentifierException {
        UID uid = new UID();
        Ivorn ivorn = CommunityAccountIvornFactory.createMock("", uid.toString());
        SecurityToken token = new SecurityToken(account.getAccountIdent(), ivorn.toString());
        token.setStatus(1);
        map.put(token.getToken(), token);
        return token;
    }

    public SecurityToken checkPassword(String ident, String value) throws CommunitySecurityException, CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceMock.checkPassword()");
        log.debug((Object)("  Ident : " + ident));
        log.debug((Object)("  Value : " + value));
        if (null != secret) {
            if (secret.equals(value)) {
                return this.createToken(ident);
            }
            throw new CommunitySecurityException("Invalid password");
        }
        return this.createToken(ident);
    }

    public SecurityToken checkToken(SecurityToken original) throws CommunitySecurityException, CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceMock.checkToken()");
        log.debug((Object)("  Token : " + original));
        original.setStatus(0);
        SecurityToken match = (SecurityToken)map.get(original.getToken());
        if (null != match) {
            map.remove(match.getToken());
            return this.createToken(original.getAccount());
        }
        throw new CommunitySecurityException("Original token not valid");
    }

    public Object[] splitToken(SecurityToken original, int count) throws CommunitySecurityException, CommunityIdentifierException {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceMock.splitToken()");
        log.debug((Object)("  Token : " + original));
        log.debug((Object)("  Count : " + count));
        original.setStatus(0);
        SecurityToken match = (SecurityToken)map.get(original.getToken());
        if (null != match) {
            map.remove(match.getToken());
            Vector<SecurityToken> vector = new Vector<SecurityToken>();
            for (int i = 0; i < count; ++i) {
                vector.add(this.createToken(original.getAccount()));
            }
            return vector.toArray();
        }
        throw new CommunitySecurityException("Original token not valid");
    }
}

