/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.security.service;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.manager.AccountManager;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.common.security.manager.SecurityManager;
import org.astrogrid.community.common.security.service.SecurityService;
import org.astrogrid.community.common.service.CommunityServiceTest;

public class SecurityServiceTest
extends CommunityServiceTest {
    private static Log log = LogFactory.getLog((Class)SecurityServiceTest.class);
    public static String TEST_ACCOUNT = "test-account";
    public static String TEST_PASSWORD = "test-password";
    private AccountManager accountManager;
    private SecurityManager securityManager;
    private SecurityService securityService;
    private static int SPLIT_COUNT = 3;

    public AccountManager getAccountManager() {
        return this.accountManager;
    }

    public void setAccountManager(AccountManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.setAccountManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.accountManager = manager;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.setSecurityManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.securityManager = manager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService service) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.setSecurityService()");
        log.debug((Object)("  Service : " + service.getClass()));
        this.securityService = service;
        this.setCommunityService(this.securityService);
    }

    public void testCheckPassword() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.testCheckPassword()");
        AccountData account = this.accountManager.addAccount(this.createLocal(TEST_ACCOUNT).toString());
        SecurityServiceTest.assertNotNull((String)"addAccount returned null", (Object)account);
        SecurityServiceTest.assertTrue((String)"setPassword returned false", (boolean)this.securityManager.setPassword(account.getIdent(), TEST_PASSWORD));
        SecurityToken token = this.securityService.checkPassword(account.getIdent(), TEST_PASSWORD);
        SecurityServiceTest.assertNotNull((String)"checkPassword returned NULL", (Object)token);
        SecurityServiceTest.assertEquals((String)"Token has wrong account", (String)account.getIdent(), (String)token.getAccount());
        SecurityServiceTest.assertTrue((String)"Token is not valid", (boolean)token.isValid());
    }

    public void testCheckToken() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.testCheckToken()");
        AccountData account = this.accountManager.addAccount(this.createLocal(TEST_ACCOUNT).toString());
        SecurityServiceTest.assertNotNull((String)"addAccount returned null", (Object)account);
        SecurityServiceTest.assertTrue((String)"setPassword returned false", (boolean)this.securityManager.setPassword(account.getIdent(), TEST_PASSWORD));
        SecurityToken original = this.securityService.checkPassword(account.getIdent(), TEST_PASSWORD);
        SecurityServiceTest.assertNotNull((String)"NULL original token", (Object)original);
        SecurityServiceTest.assertEquals((String)"Token has wrong account", (String)account.getIdent(), (String)original.getAccount());
        SecurityServiceTest.assertTrue((String)"Token is not valid", (boolean)original.isValid());
        SecurityToken response = this.securityService.checkToken(original);
        SecurityServiceTest.assertNotNull((String)"NULL response token", (Object)response);
        SecurityServiceTest.assertEquals((String)"Token has wrong account", (String)account.getIdent(), (String)response.getAccount());
        SecurityServiceTest.assertTrue((String)"Token is not valid", (boolean)response.isValid());
        this.checkNotEqual("Token has same value", original.getToken(), response.getToken());
        this.checkNotEqual("Token are equal", original, response);
        try {
            this.securityService.checkToken(original);
            SecurityServiceTest.fail((String)"Expected CommunitySecurityException");
        }
        catch (CommunitySecurityException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        SecurityServiceTest.assertFalse((String)"Original token still valid", (boolean)original.isValid());
    }

    public void testSplitToken() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"SecurityServiceTest.testSplitToken()");
        AccountData account = this.accountManager.addAccount(this.createLocal(TEST_ACCOUNT).toString());
        SecurityServiceTest.assertNotNull((String)"addAccount returned null", (Object)account);
        SecurityServiceTest.assertTrue((String)"setPassword returned false", (boolean)this.securityManager.setPassword(account.getIdent(), TEST_PASSWORD));
        SecurityToken original = this.securityService.checkPassword(account.getIdent(), TEST_PASSWORD);
        SecurityServiceTest.assertNotNull((String)"NULL original token", (Object)original);
        SecurityServiceTest.assertEquals((String)"Token has wrong account", (String)account.getIdent(), (String)original.getAccount());
        SecurityServiceTest.assertTrue((String)"Token is not valid", (boolean)original.isValid());
        Object[] array = this.securityService.splitToken(original, SPLIT_COUNT);
        SecurityServiceTest.assertNotNull((String)"NULL token array", (Object)array);
        SecurityServiceTest.assertTrue((String)"Wrong number of tokens", (array.length == SPLIT_COUNT ? 1 : 0) != 0);
        for (int i = 0; i < array.length; ++i) {
            SecurityToken token = (SecurityToken)array[i];
            SecurityServiceTest.assertEquals((String)"Token has wrong account", (String)account.getIdent(), (String)token.getAccount());
            SecurityServiceTest.assertTrue((String)"Token is not valid", (boolean)token.isValid());
            this.checkNotEqual("Token has same value", original.getToken(), token.getToken());
            this.checkNotEqual("Token are equal", original, token);
        }
        try {
            this.securityService.checkToken(original);
            SecurityServiceTest.fail((String)"Expected CommunitySecurityException");
        }
        catch (CommunitySecurityException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
        }
        catch (RemoteException ouch) {
            log.debug((Object)"Caught expected Exception");
            log.debug((Object)("Exception : " + ouch));
            log.debug((Object)("Class     : " + ouch.getClass()));
        }
        SecurityServiceTest.assertFalse((String)"Original token still valid", (boolean)original.isValid());
    }
}

