/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.common.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.database.manager.DatabaseManager;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityAccountIvornFactory;
import org.astrogrid.community.common.junit.JUnitTestBase;
import org.astrogrid.community.common.service.CommunityService;
import org.astrogrid.community.common.service.data.ServiceStatusData;
import org.astrogrid.store.Ivorn;

public class CommunityServiceTest
extends JUnitTestBase {
    private static Log log = LogFactory.getLog((Class)CommunityServiceTest.class);
    private CommunityService communityService;
    private DatabaseManager databaseManager;

    public CommunityServiceTest() {
    }

    public CommunityServiceTest(CommunityService service) {
        this.setCommunityService(service);
    }

    public Ivorn createLocal(String ident) throws CommunityServiceException, CommunityIdentifierException {
        return CommunityAccountIvornFactory.createLocal(ident);
    }

    public CommunityService getCommunityService() {
        return this.communityService;
    }

    public void setCommunityService(CommunityService service) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityServiceTest.setCommunityService()");
        log.debug((Object)("  Service : " + service.getClass()));
        this.communityService = service;
    }

    public void testServiceStatus() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityServiceTest.testServiceStatus()");
        log.debug((Object)("  Service : " + this.communityService.getClass()));
        CommunityServiceTest.assertNotNull((Object)this.communityService.getServiceStatus());
    }

    public void testServiceMemory() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityServiceTest.testServiceMemory()");
        log.debug((Object)("  Service : " + this.communityService.getClass()));
        ServiceStatusData status = this.communityService.getServiceStatus();
        log.info((Object)("Free  memory : " + status.getFreeMemory()));
        log.info((Object)("Total memory : " + status.getTotalMemory()));
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public void setDatabaseManager(DatabaseManager manager) {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityServiceTest.setDatabaseManager()");
        log.debug((Object)("  Manager : " + manager.getClass()));
        this.databaseManager = manager;
    }

    public void resetDatabase() throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"CommunityServiceTest:resetDatabase()");
        this.databaseManager.resetDatabaseTables();
    }
}

