/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.Msrl;

public class Agfi {
    private URL url = null;
    private Msrl msrl = null;
    private Ivorn ivorn = null;
    private String account = null;
    private String email = null;
    public static final String SCHEME = "astrogrid:file";
    public static final String FORM = "astrogrid:file:[<Msrl>|<URL>|<IVORN>][#path]";

    public Agfi(URL aUrl) {
        this.url = aUrl;
    }

    public Agfi(Ivorn anIvorn) {
        this.ivorn = anIvorn;
    }

    public Agfi(Msrl aMyspaceResourceLocation) {
        this.msrl = aMyspaceResourceLocation;
    }

    public Agfi(String rl) throws URISyntaxException {
        rl = rl.trim();
        if (!rl.toLowerCase().startsWith("astrogrid:file:")) {
            throw new URISyntaxException(rl, "AGFI is not of the right form: astrogrid:file:[<Msrl>|<URL>|<IVORN>][#path]");
        }
        if ((rl = rl.substring(SCHEME.length() + 1)).toLowerCase().startsWith("mailto:")) {
            this.email = rl.substring("mailto".length() + 1);
        } else {
            if (Msrl.isMsrl(rl)) {
                try {
                    this.msrl = new Msrl(rl);
                }
                catch (MalformedURLException mue) {
                    throw new URISyntaxException(rl, mue.toString());
                }
            }
            if (!rl.equals("null")) {
                if (Ivorn.isIvorn((String)rl)) {
                    this.ivorn = new Ivorn(rl);
                } else {
                    try {
                        this.url = new URL(rl);
                        if (this.url.getAuthority() != null && this.url.getAuthority().indexOf("#") > -1) {
                            this.url = new URL(this.url.getProtocol(), this.url.getHost().substring(0, this.url.getHost().indexOf(35)), this.url.getPort(), "#" + this.url.getRef());
                        }
                    }
                    catch (MalformedURLException mue) {
                        throw new URISyntaxException(rl, mue.toString());
                    }
                }
            }
        }
    }

    public String toString() {
        if (this.msrl != null) {
            return "astrogrid:file:" + this.msrl.toString();
        }
        if (this.url != null) {
            return "astrogrid:file:" + this.url.toString();
        }
        if (this.ivorn != null) {
            return "astrogrid:file:" + this.ivorn.toString();
        }
        if (this.email != null) {
            return "astrogrid:file:mailto:" + this.email;
        }
        if (this.account != null) {
            throw new UnsupportedOperationException("Not done yet");
        }
        return "astrogrid:file:null";
    }

    public static boolean isAgfi(String agfi) {
        return agfi.toLowerCase().startsWith("astrogrid:file:");
    }

    public boolean isNull() {
        return this.url == null && this.msrl == null && this.ivorn == null && this.email == null && this.account == null;
    }

    public URL getUrl() {
        return this.url;
    }

    public Msrl getMsrl() {
        return this.msrl;
    }

    public String getEmail() {
        return this.email;
    }

    public Ivorn getIvorn() {
        return this.ivorn;
    }

    public String getAccount() {
        return this.account;
    }

    public boolean equals(Object anAgsl) {
        return this.toString().equals(anAgsl.toString());
    }
}

