/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.astrogrid.community.User;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.Msrl;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;

public class Agsl {
    private URL url = null;
    private Msrl msrl = null;
    public static final String SCHEME = "astrogrid:store";
    public static final String FORM = "astrogrid:store:[<Msrl>|<URL>][#path]";

    public Agsl(URL aUrl) {
        this.url = aUrl;
    }

    public Agsl(Msrl aMyspaceResourceLocation) {
        this.msrl = aMyspaceResourceLocation;
    }

    public Agsl(Msrl myspaceEndpoint, String path) throws MalformedURLException {
        this.init(myspaceEndpoint, path);
    }

    public Agsl(URL storepoint, String path) throws MalformedURLException {
        this.init(storepoint, path);
    }

    public Agsl(Agsl storepoint, String path) throws MalformedURLException {
        this.init(storepoint, path);
    }

    public Agsl(String rl) throws MalformedURLException {
        rl = rl.trim();
        if (rl.toLowerCase().startsWith("mailto:")) {
            rl = "astrogrid:store:" + rl;
        }
        if (!rl.toLowerCase().startsWith("astrogrid:store:")) {
            throw new MalformedURLException("AGSL '" + rl + "' is not of the right form: " + FORM);
        }
        if (Msrl.isMsrl(rl = rl.substring(SCHEME.length() + 1))) {
            this.msrl = new Msrl(rl);
        } else {
            this.url = new URL(rl);
            if (this.url.getAuthority() != null && this.url.getAuthority().indexOf("#") > -1) {
                this.url = new URL(this.url.getProtocol(), this.url.getHost().substring(0, this.url.getHost().indexOf(35)), this.url.getPort(), "#" + this.url.getRef());
            }
        }
    }

    private void init(Msrl myspacestore, String path) {
        if (myspacestore == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        if (myspacestore.getPath() != null) {
            throw new IllegalArgumentException("endpoint '" + myspacestore + "' includes a file path");
        }
        this.msrl = path == null ? myspacestore : new Msrl(myspacestore.getDelegateEndpoint(), path);
    }

    private void init(URL storepoint, String path) throws MalformedURLException {
        if (storepoint == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        if (storepoint.getRef() != null) {
            throw new IllegalArgumentException("endpoint '" + storepoint + "' includes a fragment/reference");
        }
        this.url = path == null ? storepoint : new URL(storepoint + "#" + path);
    }

    private void init(Agsl storepoint, String path) throws MalformedURLException {
        if (storepoint == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        if (storepoint.getPath() != null) {
            throw new IllegalArgumentException("endpoint '" + storepoint + "' includes a path");
        }
        if (Msrl.isMsrl(storepoint.getEndpoint())) {
            this.init(new Msrl(storepoint.getEndpoint()), path);
        } else {
            this.init(new URL(storepoint.getEndpoint()), path);
        }
    }

    public String toString() {
        if (this.msrl != null) {
            return "astrogrid:store:" + this.msrl.toString();
        }
        return "astrogrid:store:" + this.url.toString();
    }

    public URI toUri() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Application error: " + e + " for AGSL " + this.toString());
        }
    }

    public static boolean isAgsl(String agsl) {
        return agsl.toLowerCase().startsWith("astrogrid:store:") || agsl.toLowerCase().startsWith("vospace:");
    }

    public String getEndpoint() {
        if (this.url != null) {
            return this.url.getProtocol() + "://" + this.url.getAuthority() + this.url.getPath();
        }
        return "myspace:" + this.msrl.getDelegateEndpoint().toString();
    }

    public String getPath() {
        if (this.url != null) {
            return this.url.getRef();
        }
        return this.msrl.getPath();
    }

    public String getFilename() {
        if (this.url != null) {
            String path = this.url.getRef();
            if (path != null) {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                int slash = path.lastIndexOf("/");
                return path.substring(slash + 1);
            }
            return null;
        }
        return this.msrl.getFilename();
    }

    public InputStream openInputStream(User user) throws IOException {
        StoreClient client = StoreDelegateFactory.createDelegate(user, this);
        return client.getStream(this.getPath());
    }

    public OutputStream openOutputStream(User user) throws IOException {
        StoreClient client = StoreDelegateFactory.createDelegate(user, this);
        return client.putStream(this.getPath(), false);
    }

    public URL resolveURL() throws IOException {
        if (this.url != null) {
            return this.url;
        }
        return this.msrl.resolveURL();
    }

    public String getScheme() {
        if (this.url != null) {
            return "astrogrid:store:" + this.url.getProtocol();
        }
        return "astrogrid:store:myspace";
    }

    public Ivorn toIvorn(User user) {
        return new Ivorn(user.getCommunity(), user.getUserId(), this.getPath());
    }

    public boolean equals(Object anAgsl) {
        return this.toString().equals(anAgsl.toString());
    }
}

