/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.astrogrid.community.User;
import org.astrogrid.log.Log;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;

public class Msrl {
    private String serverId = null;
    private URL delegateEndpoint = null;
    private Ivorn manager = null;
    private String filepath = null;
    public static final String SCHEME = "myspace";
    public static final String FORM = "myspace:<delegateEndPoint>[#<MySpacePath>[!<Server>]]";
    static final /* synthetic */ boolean $assertionsDisabled;

    public Msrl(URL aDelegateEndpoint) {
        this.delegateEndpoint = aDelegateEndpoint;
    }

    public Msrl(URL aDelegateEndpoint, String myspacePath) {
        this.delegateEndpoint = aDelegateEndpoint;
        this.filepath = myspacePath;
    }

    public Msrl(Ivorn aManagerIvorn, String myspacePath) {
        this.manager = aManagerIvorn;
        this.filepath = myspacePath;
    }

    public Msrl(URL aDelegateEndpoint, String myspacePath, String aServer) {
        this.delegateEndpoint = aDelegateEndpoint;
        this.filepath = myspacePath;
        this.serverId = aServer;
    }

    public Msrl(String msrl) throws MalformedURLException {
        String rl;
        if (!$assertionsDisabled && !msrl.toLowerCase().startsWith("myspace:")) {
            throw new AssertionError((Object)(msrl + " is not a MySpace RL - should be of the form " + FORM));
        }
        if (!msrl.toLowerCase().startsWith("myspace:")) {
            throw new IllegalArgumentException(msrl + " is not a MySpace RL - should be of the form " + FORM);
        }
        int hashPos = msrl.indexOf(35);
        if (hashPos > -1) {
            String fragment = msrl.substring(hashPos + 1);
            msrl = msrl.substring(0, hashPos);
            int atPos = fragment.indexOf("!");
            if (atPos > -1) {
                String givenServer = fragment.substring(atPos + 1);
                fragment = fragment.substring(0, atPos);
                this.serverId = givenServer;
            }
            this.filepath = fragment;
        }
        if (Ivorn.isIvorn((String)(rl = msrl.substring(SCHEME.length() + 1)))) {
            try {
                this.manager = new Ivorn(rl);
            }
            catch (URISyntaxException use) {
                throw new MalformedURLException("" + use);
            }
        } else {
            this.delegateEndpoint = new URL(rl);
        }
    }

    public String toString() {
        String msrl = "myspace:";
        msrl = this.delegateEndpoint != null ? msrl + this.delegateEndpoint : msrl + this.manager;
        if (this.filepath != null) {
            msrl = msrl + "#" + this.filepath;
        }
        if (this.serverId != null) {
            msrl = msrl + "!" + this.serverId;
        }
        return msrl;
    }

    public URL getDelegateEndpoint() {
        return this.delegateEndpoint;
    }

    public Ivorn getManagerIvorn() {
        return this.manager;
    }

    public String getPath() {
        return this.filepath;
    }

    public String getServer() {
        return this.serverId;
    }

    public String getFilename() {
        String path = this.getPath();
        if (path != null) {
            int slash = path.lastIndexOf("/");
            return path.substring(slash + 1);
        }
        return null;
    }

    public String getName() {
        String path = this.getPath();
        if (path != null) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            int slash = path.lastIndexOf("/");
            return path.substring(slash + 1);
        }
        return null;
    }

    public Msrl getManagerMsrl() {
        return new Msrl(this.delegateEndpoint);
    }

    public static boolean isMsrl(String msrl) {
        return msrl.toLowerCase().startsWith("myspace:");
    }

    public InputStream openInputStream() throws IOException {
        return this.resolveURL().openStream();
    }

    public OutputStream openOutputStream() throws IOException {
        StoreClient myspace = StoreDelegateFactory.createDelegate(User.ANONYMOUS, new Agsl(this));
        return myspace.putStream(this.getPath(), false);
    }

    public URL resolveURL() throws IOException {
        StoreClient myspace = StoreDelegateFactory.createDelegate(User.ANONYMOUS, new Agsl(this));
        URL url = myspace.getUrl(this.getPath());
        Log.trace((String)("Loc '" + this.getDelegateEndpoint() + "' + path '" + this.getPath() + "' -> URL '" + url + "'"));
        return url;
    }

    static {
        $assertionsDisabled = !Msrl.class.desiredAssertionStatus();
    }
}

