/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.astrogrid.community.User;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.delegate.ResolverException;
import org.astrogrid.store.delegate.StoreAdminClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;
import org.astrogrid.store.delegate.StoreException;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.VoSpaceResolver;

public class VoSpaceClient {
    private User operator = null;

    public VoSpaceClient(User anOperator) {
        this.operator = anOperator;
    }

    public User getOperator() {
        return this.operator;
    }

    public StoreFile getFile(Ivorn fileIvorn) throws IOException {
        Agsl fileAgsl = VoSpaceResolver.resolveAgsl(fileIvorn);
        StoreClient client = StoreDelegateFactory.createDelegate(this.operator, fileAgsl);
        return client.getFile(fileAgsl.getPath());
    }

    public StoreClient getDelegate(Ivorn storeIvorn) throws IOException {
        Agsl storeAgsl = VoSpaceResolver.resolveAgsl(storeIvorn);
        return StoreDelegateFactory.createDelegate(this.operator, storeAgsl);
    }

    public void putBytes(byte[] bytes, int offset, int length, Ivorn targetIvorn, boolean append) throws IOException {
        Agsl fileAgsl = VoSpaceResolver.resolveAgsl(targetIvorn);
        StoreClient client = StoreDelegateFactory.createDelegate(this.operator, fileAgsl);
        client.putBytes(bytes, offset, length, fileAgsl.getPath(), append);
    }

    public void putUrl(URL source, Ivorn targetIvorn, boolean append) throws IOException {
        Agsl fileAgsl = VoSpaceResolver.resolveAgsl(targetIvorn);
        StoreClient client = StoreDelegateFactory.createDelegate(this.operator, fileAgsl);
        client.putUrl(source, fileAgsl.getPath(), append);
    }

    public OutputStream putStream(Ivorn target) throws IOException {
        return VoSpaceResolver.resolveOutputStream(this.getOperator(), target);
    }

    public InputStream getStream(Ivorn source) throws IOException {
        return VoSpaceResolver.resolveInputStream(this.getOperator(), source);
    }

    public void delete(Ivorn toDelete) throws IOException {
        Agsl fileAgsl = VoSpaceResolver.resolveAgsl(toDelete);
        StoreClient client = StoreDelegateFactory.createDelegate(this.operator, fileAgsl);
        client.delete(fileAgsl.getPath());
    }

    public void copy(Ivorn source, Ivorn target) throws IOException {
        Agsl sourceAgsl = VoSpaceResolver.resolveAgsl(source);
        Agsl targetAgsl = VoSpaceResolver.resolveAgsl(target);
        StoreClient sourceClient = StoreDelegateFactory.createDelegate(this.operator, sourceAgsl);
        sourceClient.copy(sourceAgsl.getPath(), targetAgsl);
    }

    public void move(Ivorn source, Ivorn target) throws IOException {
        Agsl sourceAgsl = VoSpaceResolver.resolveAgsl(source);
        Agsl targetAgsl = VoSpaceResolver.resolveAgsl(target);
        StoreClient sourceClient = StoreDelegateFactory.createDelegate(this.operator, sourceAgsl);
        sourceClient.move(sourceAgsl.getPath(), targetAgsl);
    }

    public void newFolder(Ivorn target) throws IOException {
        Agsl fileAgsl = VoSpaceResolver.resolveAgsl(target);
        StoreClient client = StoreDelegateFactory.createDelegate(this.operator, fileAgsl);
        client.newFolder(fileAgsl.getPath());
    }

    public Ivorn createUser(Ivorn targetVoSpace, Ivorn user) throws IOException, URISyntaxException {
        StoreAdminClient client = VoSpaceResolver.resolveStoreAdmin(this.operator, targetVoSpace);
        CommunityIvornParser ci = null;
        try {
            ci = new CommunityIvornParser(user);
        }
        catch (Exception e) {
            throw new StoreException("Could not parse ivorn user ", e);
        }
        client.createUser(new User(ci.getAccountName(), ci.getCommunityName(), "Anonymous", "None"));
        return new Ivorn(targetVoSpace.toString());
    }

    public void deleteUser(Ivorn target, Ivorn user) throws IOException {
        StoreAdminClient client = VoSpaceResolver.resolveStoreAdmin(this.operator, target);
        CommunityIvornParser ci = null;
        try {
            ci = new CommunityIvornParser(user);
        }
        catch (Exception e) {
            throw new ResolverException("Could not parse ivorn user ", e);
        }
        client.deleteUser(new User(ci.getAccountName(), ci.getCommunityName(), "Anonymous", "None"));
    }
}

