/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.adapter.aladin;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.adapter.aladin.AladinAdapter;
import org.astrogrid.store.adapter.aladin.AladinAdapterContainer;
import org.astrogrid.store.adapter.aladin.AladinAdapterDuplicateException;
import org.astrogrid.store.adapter.aladin.AladinAdapterFile;
import org.astrogrid.store.adapter.aladin.AladinAdapterLoginException;
import org.astrogrid.store.adapter.aladin.AladinAdapterNode;
import org.astrogrid.store.adapter.aladin.AladinAdapterSecurityException;
import org.astrogrid.store.adapter.aladin.AladinAdapterServiceException;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.tree.Container;
import org.astrogrid.store.tree.File;
import org.astrogrid.store.tree.IterationSixTreeClient;
import org.astrogrid.store.tree.Node;
import org.astrogrid.store.tree.TreeClientDuplicateException;
import org.astrogrid.store.tree.TreeClientLoginException;
import org.astrogrid.store.tree.TreeClientSecurityException;
import org.astrogrid.store.tree.TreeClientServiceException;

public class IterationSixAladinAdapter
implements AladinAdapter {
    private static final Log logger = LogFactory.getLog((Class)IterationSixAladinAdapter.class);
    protected final IterationSixTreeClient treeclient = new IterationSixTreeClient();

    public void login(Ivorn communityIvorn, String password) throws AladinAdapterLoginException, AladinAdapterServiceException {
        try {
            this.treeclient.login(communityIvorn, password);
        }
        catch (TreeClientLoginException e) {
            throw new AladinAdapterLoginException(e.getMessage(), e);
        }
        catch (TreeClientServiceException e) {
            throw new AladinAdapterServiceException(e.getMessage(), e);
        }
    }

    public StoreClient getStoreClient() {
        return this.treeclient.getStoreClient();
    }

    public void logout() throws AladinAdapterServiceException {
        try {
            this.treeclient.logout();
        }
        catch (TreeClientServiceException e) {
            throw new AladinAdapterServiceException(e.getMessage(), e);
        }
    }

    public SecurityToken getToken() {
        return this.treeclient.getToken();
    }

    public AladinAdapterContainer getRoot() throws AladinAdapterSecurityException, AladinAdapterServiceException {
        Container root;
        try {
            root = this.treeclient.getRoot();
        }
        catch (TreeClientSecurityException e) {
            throw new AladinAdapterSecurityException(e.getMessage(), e);
        }
        catch (TreeClientServiceException e) {
            throw new AladinAdapterServiceException(e.getMessage(), e);
        }
        return this.wrapRoot(root);
    }

    private final AladinAdapterContainer wrapRoot(Container c) {
        return new IterationSixContainer(c);
    }

    protected class IterationSixFile
    extends IterationSixNode
    implements AladinAdapterFile {
        public IterationSixFile(File node) {
            super(node);
        }

        public String getMimeType() {
            return ((File)this.node).getMimeType();
        }

        public OutputStream getOutputStream() throws AladinAdapterServiceException {
            try {
                return ((File)this.node).getOutputStream();
            }
            catch (TreeClientServiceException e) {
                throw new AladinAdapterServiceException(e.getMessage(), e);
            }
        }

        public InputStream getInputStream() throws AladinAdapterServiceException {
            try {
                return ((File)this.node).getInputStream();
            }
            catch (TreeClientServiceException e) {
                throw new AladinAdapterServiceException(e.getMessage(), e);
            }
        }
    }

    protected class IterationSixContainer
    extends IterationSixNode
    implements AladinAdapterContainer {
        public IterationSixContainer(Container c) {
            super(c);
        }

        public Collection getChildNodes() {
            Collection orig = ((Container)this.node).getChildNodes();
            ArrayList<IterationSixNode> wrapped = new ArrayList<IterationSixNode>(orig.size());
            Iterator i = orig.iterator();
            while (i.hasNext()) {
                wrapped.add(this.wrap(i.next()));
            }
            return Collections.unmodifiableCollection(wrapped);
        }

        private IterationSixNode wrap(Object o) {
            if (o instanceof Container) {
                return new IterationSixContainer((Container)o);
            }
            if (o instanceof File) {
                return new IterationSixFile((File)o);
            }
            throw new RuntimeException("Programming Error - unknown object type" + o.getClass().getName());
        }

        public AladinAdapterContainer addContainer(String name) throws AladinAdapterServiceException, AladinAdapterDuplicateException {
            try {
                return new IterationSixContainer(((Container)this.node).addContainer(name));
            }
            catch (TreeClientServiceException e) {
                throw new AladinAdapterServiceException(e.getMessage(), e);
            }
            catch (TreeClientDuplicateException e) {
                throw new AladinAdapterDuplicateException(e.getMessage());
            }
        }

        public AladinAdapterFile addFile(String name) throws AladinAdapterServiceException, AladinAdapterDuplicateException {
            try {
                return new IterationSixFile(((Container)this.node).addFile(name));
            }
            catch (TreeClientServiceException e) {
                throw new AladinAdapterServiceException(e.getMessage(), e);
            }
            catch (TreeClientDuplicateException e) {
                throw new AladinAdapterDuplicateException(e.getMessage());
            }
        }
    }

    protected class IterationSixNode
    implements AladinAdapterNode {
        protected final Node node;

        public IterationSixNode(Node n) {
            this.node = n;
        }

        public String getName() {
            return this.node.getName();
        }

        public boolean isFile() {
            return this.node.isFile();
        }

        public boolean isContainer() {
            return this.node.isContainer();
        }

        public boolean equals(Object obj) {
            IterationSixNode casted = (IterationSixNode)obj;
            return this.node.equals(casted.node);
        }

        public String toString() {
            return "AladinAdapter : " + this.node.toString();
        }
    }
}

