/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.User;
import org.astrogrid.io.Piper;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;
import org.astrogrid.store.delegate.StoreFile;

public abstract class StoreDelegate
implements StoreClient {
    private User operator = User.ANONYMOUS;
    protected Log log = LogFactory.getLog((Class)StoreDelegate.class);

    public StoreDelegate(User anOperator) {
        this.operator = anOperator;
    }

    public User getOperator() {
        return this.operator;
    }

    public void putUrl(URL source, String targetPath, boolean append) throws IOException {
        OutputStream out = this.putStream(targetPath, append);
        InputStream in = source.openStream();
        Piper.bufferedPipe((InputStream)in, (OutputStream)out);
        out.close();
        in.close();
    }

    public void putBytes(byte[] bytes, int offset, int length, String targetPath, boolean append) throws IOException {
        OutputStream out = this.putStream(targetPath, append);
        out.write(bytes, offset, length);
        out.close();
    }

    public void putString(String contents, String targetPath, boolean append) throws IOException {
        byte[] b = contents.getBytes();
        this.putBytes(b, 0, b.length, targetPath, append);
    }

    public void copy(String sourcePath, Agsl target) throws IOException {
        StoreClient targetClient = StoreDelegateFactory.createDelegate(this.getOperator(), target);
        InputStream in = this.getStream(sourcePath);
        OutputStream out = targetClient.putStream(target.getPath(), false);
        Piper.bufferedPipe((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
    }

    public void copy(Agsl source, String targetPath) throws IOException {
        StoreClient sourceClient = StoreDelegateFactory.createDelegate(this.getOperator(), source);
        InputStream in = sourceClient.getStream(source.getPath());
        OutputStream out = this.putStream(targetPath, false);
        Piper.bufferedPipe((InputStream)in, (OutputStream)out);
        in.close();
        out.close();
    }

    public void move(String sourcePath, Agsl targetPath) throws IOException {
        this.copy(sourcePath, targetPath);
        this.delete(sourcePath);
    }

    public void move(Agsl source, String targetPath) throws IOException {
        this.copy(source, targetPath);
        StoreClient client = StoreDelegateFactory.createDelegate(this.getOperator(), source);
        client.delete(source.getPath());
    }

    public Agsl getAgsl(String sourcePath) throws IOException {
        return new Agsl(this.getEndpoint() + "#" + sourcePath);
    }

    public static void printTree(StoreFile root, Writer writer) throws IOException {
        writer.write(root.getPath() + ",  " + root.getMimeType() + ",  " + root.getSize() + ", " + root.getModified() + "\n");
        StoreFile[] children = root.listFiles();
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                StoreDelegate.printTree(root, writer);
            }
        }
    }
}

