/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate;

import java.io.IOException;
import java.net.URL;
import org.astrogrid.community.User;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.Msrl;
import org.astrogrid.store.delegate.StoreAdminClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.ftp.FtpStore;
import org.astrogrid.store.delegate.local.LocalFileStore;
import org.astrogrid.store.delegate.myspaceItn05.MySpaceIt05Delegate;

public class StoreDelegateFactory {
    public static StoreClient createDelegate(User operator, Agsl location) throws IOException {
        if (location.getScheme().startsWith("astrogrid:store:myspace")) {
            return new MySpaceIt05Delegate(operator, location.getEndpoint().toString());
        }
        if (location.getScheme().startsWith("astrogrid:store:ftp")) {
            return new FtpStore(operator, location);
        }
        if (location.getScheme().startsWith("astrogrid:store:file")) {
            return new LocalFileStore(location);
        }
        throw new IllegalArgumentException("Don't know how to create delegate for AGSL '" + location + "'");
    }

    public static StoreClient createDelegate(User operator, String storeUri) throws IOException {
        if (Msrl.isMsrl(storeUri)) {
            return new MySpaceIt05Delegate(operator, new Msrl(storeUri).getDelegateEndpoint().toString());
        }
        if (storeUri.toLowerCase().startsWith("ftp:")) {
            return new FtpStore(operator, new URL(storeUri));
        }
        if (storeUri.toLowerCase().startsWith("file:")) {
            return new LocalFileStore("Default");
        }
        throw new IllegalArgumentException("Don't know how to create store delegate for '" + storeUri + "'");
    }

    public static StoreAdminClient createAdminDelegate(User operator, Agsl location) throws IOException {
        if (location.getScheme().startsWith("astrogrid:store:myspace") && location.getEndpoint().endsWith("/Manager")) {
            return new MySpaceIt05Delegate(operator, location.getEndpoint().toString());
        }
        if (location.getScheme().startsWith("astrogrid:store:file")) {
            return new LocalFileStore(location);
        }
        throw new IllegalArgumentException("Don't know how to create administration delegate for AGSL '" + location + "'");
    }
}

