/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.User;
import org.astrogrid.community.common.exception.CommunityException;
import org.astrogrid.community.resolver.CommunityAccountSpaceResolver;
import org.astrogrid.community.resolver.exception.CommunityResolverException;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.client.RegistryDelegateFactory;
import org.astrogrid.registry.client.query.RegistryService;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.Msrl;
import org.astrogrid.store.delegate.ResolverException;
import org.astrogrid.store.delegate.StoreAdminClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;

public class VoSpaceResolver {
    private static RegistryService registry = null;
    private static CommunityAccountSpaceResolver community = null;
    private static Log log = LogFactory.getLog((Class)VoSpaceResolver.class);
    private static final String VOSPACE_CLASS_RESOURCE_KEY_LOOKUP = "myspace";
    public static final String AUTOINT_MYSPACE_IVOKEY = "org.astrogrid.localhost/myspace";
    public static final String AUTOINT_MYSPACE_AGSL = "astrogrid:store:myspace:http://localhost:8080/astrogrid-mySpace-SNAPSHOT/services/Manager";

    public static Agsl resolveAgsl(Ivorn ivorn) throws IOException {
        Agsl agsl;
        String lookedIn;
        String fragment;
        block13: {
            fragment = "";
            if (ivorn.getFragment() != null) {
                fragment = "#" + ivorn.getFragment();
            }
            lookedIn = "";
            agsl = null;
            String s = SimpleConfig.getSingleton().getString(ivorn.getPath(), null);
            lookedIn = lookedIn + "Config (key=" + ivorn.getPath() + ") ";
            if (s != null) {
                agsl = new Agsl(s + fragment);
            }
            try {
                if (agsl == null) {
                    try {
                        Ivorn homespace = VoSpaceResolver.getCommunityMySpace(ivorn);
                        lookedIn = lookedIn + ", Community " + community + "(->" + homespace + ")";
                        if (homespace != null) {
                            ivorn = homespace;
                        }
                    }
                    catch (ResolverException ce) {
                        log.warn((Object)(ce + " trying to resolve " + ivorn + " with community " + community), (Throwable)ce);
                    }
                }
                if (agsl == null) {
                    agsl = VoSpaceResolver.resolveUsingRegistry(ivorn);
                    lookedIn = lookedIn + ", Registry " + registry;
                }
            }
            catch (IOException ie) {
                if (!ivorn.getPath().toString().equals(AUTOINT_MYSPACE_IVOKEY)) {
                    throw ie;
                }
            }
            catch (RuntimeException re) {
                if (ivorn.getPath().toString().equals(AUTOINT_MYSPACE_IVOKEY)) break block13;
                throw re;
            }
        }
        if (agsl == null && ivorn.getPath().toString().equals(AUTOINT_MYSPACE_IVOKEY)) {
            agsl = new Agsl(AUTOINT_MYSPACE_AGSL + fragment);
        }
        if (agsl == null) {
            throw new FileNotFoundException("Cannot resolve " + ivorn + " from " + lookedIn);
        }
        log.trace((Object)("Resolved " + ivorn + " to " + agsl));
        return agsl;
    }

    public static StoreClient resolveStore(User user, Ivorn ivorn) throws IOException {
        return StoreDelegateFactory.createDelegate(user, VoSpaceResolver.resolveAgsl(ivorn));
    }

    public static StoreAdminClient resolveStoreAdmin(User user, Ivorn ivorn) throws IOException {
        return StoreDelegateFactory.createAdminDelegate(user, VoSpaceResolver.resolveAgsl(ivorn));
    }

    public static InputStream resolveInputStream(User user, Ivorn ivorn) throws IOException {
        return VoSpaceResolver.resolveAgsl(ivorn).openInputStream(user);
    }

    public static OutputStream resolveOutputStream(User user, Ivorn ivorn) throws IOException {
        return VoSpaceResolver.resolveAgsl(ivorn).openOutputStream(user);
    }

    private static Agsl resolveUsingRegistry(Ivorn ivorn) throws IOException {
        if (ivorn == null) {
            throw new IllegalArgumentException("Cannot resolve null ivorn");
        }
        if (registry == null) {
            VoSpaceResolver.makeRegistryDelegate();
        }
        try {
            String endPoint = registry.getEndPointByIdentifier(ivorn.getPath());
            if (endPoint == null) {
                return null;
            }
            return new Agsl(new Msrl("myspace:" + endPoint), ivorn.getFragment());
        }
        catch (RegistryException e) {
            throw new ResolverException("Failed to find agsl endpoint for '" + ivorn + "' using " + registry);
        }
    }

    private static synchronized void makeRegistryDelegate() throws IOException {
        if (registry == null) {
            registry = RegistryDelegateFactory.createQuery();
        }
    }

    private static Ivorn getCommunityMySpace(Ivorn communityIvorn) throws IOException {
        if (community == null) {
            VoSpaceResolver.makeCommunityDelegate();
        }
        try {
            Ivorn commIvo = community.resolve(communityIvorn);
            return commIvo;
        }
        catch (CommunityResolverException cre) {
            log.trace((Object)((Object)((Object)cre) + " resolving " + communityIvorn + " from community " + community + ", ignoring..."));
            return null;
        }
        catch (CommunityException e) {
            throw new ResolverException("Community " + community + " failure returning myspace for community " + communityIvorn, e);
        }
        catch (RegistryException e) {
            throw new ResolverException("Community " + community + " failed to return myspace for community " + communityIvorn, e);
        }
    }

    private static synchronized void makeCommunityDelegate() throws IOException {
        if (community == null) {
            community = new CommunityAccountSpaceResolver();
        }
    }
}

