/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import org.astrogrid.community.User;
import org.astrogrid.io.Piper;
import org.astrogrid.log.Log;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.delegate.StoreDelegate;
import org.astrogrid.store.delegate.StoreFile;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpProtocolException;

public class FtpStore
extends StoreDelegate {
    private String server = null;
    private int port = 21;
    private String rootDir = "";
    private URL endpoint = null;
    private FullFtpClient ftpConnection = null;
    private static final int DEFAULT_PORT = 21;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FtpStore(User anOperator, URL ftpEndPoint) throws IOException {
        super(anOperator);
        this.endpoint = ftpEndPoint;
        this.server = ftpEndPoint.getHost();
        this.port = ftpEndPoint.getPort();
        if (this.port == -1) {
            this.port = 21;
        }
    }

    public FtpStore(User anOperator, Agsl agsl) throws IOException {
        this(anOperator, new URL(agsl.getEndpoint()));
    }

    public Agsl getEndpoint() {
        return new Agsl(this.endpoint);
    }

    public void connect() throws IOException {
        Log.trace((String)("Connecting to " + this + "..."));
        try {
            this.ftpConnection = new FullFtpClient(this.server, this.port);
            this.ftpConnection.login(this.getOperator().getUserId(), this.getOperator().getAccount());
            this.ftpConnection.binary();
            this.ftpConnection.cd(this.rootDir);
            Log.trace((String)("...logged on to " + this.ftpConnection + "..."));
        }
        catch (IOException ioe) {
            IOException nioe = new IOException(ioe + " (" + this.ftpConnection.getResponseString() + ")");
            nioe.setStackTrace(ioe.getStackTrace());
            this.ftpConnection = null;
            throw nioe;
        }
    }

    public void disconnect() throws IOException {
        this.ftpConnection.closeServer();
        this.ftpConnection = null;
    }

    public String toString() {
        return this.getClass() + " " + this.server + ":" + this.port;
    }

    public String pushStream(String targetPath, InputStream source, boolean append) throws IOException {
        if (!$assertionsDisabled && this.ftpConnection == null) {
            throw new AssertionError((Object)"Trying to publish before connecting. Call connect() before publicise(...)");
        }
        Log.trace((String)("Publicise: Copying '" + source + "' to '" + this.server + "' as '" + targetPath + "'..."));
        this.ftpConnection.cdPath(targetPath);
        String filename = new File(targetPath).getName();
        TelnetOutputStream remoteOut = append ? this.ftpConnection.append(filename) : this.ftpConnection.put(filename);
        Piper.bufferedPipe((InputStream)source, (OutputStream)remoteOut);
        ((OutputStream)remoteOut).close();
        source.close();
        return this.ftpConnection.getUrl(this.ftpConnection.currentDir(), filename);
    }

    public String pushFile(String filename) throws IOException {
        return this.pushStream(filename, new FileInputStream(filename), false);
    }

    public String updateFromServer(String remoteUrl, String localDir) throws IOException {
        Log.affirm((boolean)localDir.endsWith("/"), (String)("'" + localDir + "' should terminate with a /"));
        int fni = remoteUrl.lastIndexOf(47);
        String filename = remoteUrl.substring(fni + 1);
        int pdi = remoteUrl.lastIndexOf(47, fni - 1);
        String dir = remoteUrl.substring(pdi + 1, fni);
        Log.trace((String)("Update: Copying '" + remoteUrl + "' to '" + localDir + "'..."));
        try {
            this.ftpConnection.cd(dir);
            BufferedInputStream remoteIn = new BufferedInputStream(this.ftpConnection.get(filename));
            BufferedOutputStream localOut = new BufferedOutputStream(new FileOutputStream(localDir + filename));
            int i = 0;
            while ((i = ((InputStream)remoteIn).read()) != -1) {
                ((OutputStream)localOut).write((byte)i);
            }
            ((InputStream)remoteIn).close();
            ((OutputStream)localOut).close();
            this.ftpConnection.cdup();
            return localDir + filename;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e + ", getting '" + filename + "' from " + this);
            ioe.fillInStackTrace();
            throw ioe;
        }
    }

    public StoreFile getFiles(String filter) throws IOException {
        throw new UnsupportedOperationException();
    }

    public StoreFile[] getChildren(StoreFile folder, String filter) throws IOException {
        throw new UnsupportedOperationException();
    }

    public StoreFile getParent(StoreFile child) throws IOException {
        throw new UnsupportedOperationException();
    }

    public StoreFile getFile(String path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputStream putStream(String targetPath, boolean append) throws IOException {
        this.ftpConnection.cdPath(targetPath);
        if (append) {
            return this.ftpConnection.append(new File(targetPath).getName());
        }
        return this.ftpConnection.put(new File(targetPath).getName());
    }

    public InputStream getStream(String sourcePath) throws IOException {
        return this.getUrl(sourcePath).openStream();
    }

    public void newFolder(String targetPath) throws IOException {
        this.ftpConnection.cdPath(new File(targetPath).getParent());
        this.ftpConnection.mkdir(new File(targetPath).getName());
    }

    public void delete(String deletePath) throws IOException {
        this.ftpConnection.delete(deletePath);
    }

    public URL getUrl(String sourcePath) throws IOException {
        this.ftpConnection.cdPath(sourcePath);
        return new URL(this.ftpConnection.getUrl(new File(sourcePath).getName()));
    }

    static {
        $assertionsDisabled = !FtpStore.class.desiredAssertionStatus();
    }

    public class FullFtpClient
    extends FtpClient {
        public FullFtpClient(String host) throws IOException {
            super(host);
        }

        public FullFtpClient(String host, int port) throws IOException {
            super(host, port);
        }

        public void mkdir(String s) throws IOException {
            this.issueCommandCheck("mkdir " + s);
        }

        public void endir(String s) throws IOException {
            block2: {
                try {
                    this.mkdir(s);
                }
                catch (FtpProtocolException fpe) {
                    if (fpe.getMessage().indexOf("521") != -1) break block2;
                    throw fpe;
                }
            }
        }

        public String getUrl(String directory, String filename) throws IOException {
            return "ftp://" + FtpStore.this.server + ":" + FtpStore.this.port + directory + "/" + filename;
        }

        public String getUrl(String filename) throws IOException {
            return "ftp://" + FtpStore.this.server + ":" + FtpStore.this.port + this.currentDir() + "/" + filename;
        }

        public void rmdir(String s) throws IOException {
            this.issueCommandCheck("RMD " + s);
        }

        public void delete(String s) throws IOException {
            this.issueCommandCheck("DELE " + s);
        }

        public String currentDir() throws IOException {
            this.issueCommandCheck("PWD");
            String response = this.getResponseString();
            return response.substring(response.indexOf(34), response.lastIndexOf(34));
        }

        public void cdup() throws IOException {
            this.issueCommandCheck("CD .. ");
        }

        public void cdPath(String targetPath) {
            throw new UnsupportedOperationException();
        }

        public int issueCommand(String cmd) throws IOException {
            Log.trace((String)("FTP>" + cmd));
            return super.issueCommand(cmd);
        }

        public int readServerResponse() throws IOException {
            int result = super.readServerResponse();
            Enumeration e = this.serverResponse.elements();
            while (e.hasMoreElements()) {
                Log.trace((String)("FTP<" + e.nextElement()));
            }
            return result;
        }

        public String toString() {
            return "Sun-derived FTP Client to " + FtpStore.this.server + ":" + FtpStore.this.port;
        }
    }
}

