/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate.local;

import java.io.File;
import java.util.Date;
import org.astrogrid.store.delegate.StoreException;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.local.LocalFileStore;

public class LocalFile
implements StoreFile {
    File file = null;
    LocalFileStore store = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LocalFile(LocalFileStore theStore, File aFile) {
        if (!$assertionsDisabled && aFile == null) {
            throw new AssertionError((Object)"Must set file");
        }
        if (!$assertionsDisabled && theStore == null) {
            throw new AssertionError((Object)"Must set store");
        }
        this.file = aFile;
        this.store = theStore;
    }

    public StoreFile[] listFiles() {
        if (!this.isFolder()) {
            return null;
        }
        File[] localFiles = this.file.listFiles();
        StoreFile[] storeFiles = new StoreFile[localFiles.length];
        for (int i = 0; i < localFiles.length; ++i) {
            storeFiles[i] = new LocalFile(this.store, localFiles[i]);
        }
        return storeFiles;
    }

    public StoreFile getParent() {
        String serverPath = this.getPath();
        if (serverPath == null) {
            return null;
        }
        return new LocalFile(this.store, this.file.getParentFile());
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        try {
            return this.store.getServerPath(this.file);
        }
        catch (StoreException se) {
            throw new RuntimeException("Program Error: ", se);
        }
    }

    public String getOwner() {
        return null;
    }

    public String getMimeType() {
        if (this.file.getName().endsWith(".txt")) {
            return "text/plain";
        }
        if (this.file.getName().endsWith(".xml")) {
            return "text/xml";
        }
        if (this.file.getName().endsWith(".vot")) {
            return "text/xml+votable";
        }
        if (this.file.getName().endsWith(".adql")) {
            return "text/xml+adql";
        }
        if (this.file.getName().endsWith(".job")) {
            return "text/xml+job";
        }
        return null;
    }

    public Date getModified() {
        return new Date(this.file.lastModified());
    }

    public Date getCreated() {
        return null;
    }

    public long getSize() {
        return this.file.length();
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public boolean equals(StoreFile anotherFile) {
        if (anotherFile instanceof LocalFile) {
            return this.file.equals(((LocalFile)anotherFile).file);
        }
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    static {
        $assertionsDisabled = !LocalFile.class.desiredAssertionStatus();
    }
}

