/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate.local;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.User;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.io.Piper;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.delegate.StoreAdminClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegate;
import org.astrogrid.store.delegate.StoreDelegateFactory;
import org.astrogrid.store.delegate.StoreException;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.local.LocalFile;

public class LocalFileStore
extends StoreDelegate
implements StoreAdminClient {
    private File rootDir = null;
    private static Log log = LogFactory.getLog((Class)LocalFileStore.class);

    public LocalFileStore() throws IOException {
        super(User.ANONYMOUS);
        String root = SimpleConfig.getSingleton().getString("LocalFileStoreRoot", null);
        if (root == null) {
            boolean success;
            this.rootDir = File.createTempFile("LocalFileStore", "Root");
            this.rootDir.delete();
            this.rootDir = new File(this.rootDir.getParentFile(), "LocalFileStore");
            if (this.rootDir.exists() && !this.rootDir.isDirectory() && !(success = this.rootDir.delete())) {
                throw new IOException("LocalFileStore [" + this.rootDir + "] is not a directory and yet cannot be deleted to make room for the local store");
            }
            if (!this.rootDir.exists()) {
                this.rootDir.mkdir();
            }
        }
    }

    public LocalFileStore(String name) throws IOException {
        this();
        this.rootDir = new File(this.rootDir, name);
        if (!this.rootDir.exists()) {
            this.rootDir.mkdir();
        }
        log.debug((Object)("LocalFileStore[" + name + "] created at " + this.rootDir));
    }

    public LocalFileStore(Agsl agsl) throws IOException {
        this(agsl.getEndpoint().substring(7));
    }

    public LocalFileStore(File givenRoot) {
        super(User.ANONYMOUS);
        this.rootDir = givenRoot;
    }

    public Agsl getEndpoint() {
        String s = "astrogrid:store:file://" + this.rootDir.getName();
        try {
            return new Agsl(s);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Program error: generating bad url '" + s + "'", mue);
        }
    }

    public void putBytes(byte[] bytes, int offset, int length, String targetPath, boolean append) throws IOException {
        File target = this.makeLocalPath(targetPath);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(target, append)));
        out.write(bytes, offset, length);
        out.close();
    }

    public URL getUrl(String sourcePath) throws IOException {
        return this.makeLocalPath(sourcePath).toURL();
    }

    public StoreFile getFiles(String filter) throws IOException {
        if (!filter.equals("*")) {
            throw new UnsupportedOperationException("Can only filter * for now");
        }
        return new LocalFile(this, this.rootDir);
    }

    public StoreFile[] getChildren(StoreFile folder, String filter) {
        if (!filter.equals("*")) {
            throw new UnsupportedOperationException("Can only filter * for now");
        }
        return new LocalFile(this, new File(folder.getPath())).listFiles();
    }

    public StoreFile getParent(StoreFile child) {
        return new LocalFile(this, new File(child.getPath()).getParentFile());
    }

    public String getServerPath(File file) throws StoreException {
        if (file.equals(this.rootDir)) {
            return null;
        }
        String path = "";
        while (file != null && !file.equals(this.rootDir)) {
            path = "/" + file.getName() + path;
            file = file.getParentFile();
        }
        if (file == null) {
            throw new StoreException("File " + file + " not in local file store " + this);
        }
        return path.substring(1);
    }

    public StoreFile getFile(String path) {
        File f = this.makeLocalPath(path);
        if (!f.exists()) {
            return null;
        }
        return new LocalFile(this, f);
    }

    public void newFolder(String targetPath) throws IOException {
        File newFolder = new File(this.rootDir, targetPath);
        newFolder.mkdir();
    }

    public OutputStream putStream(String targetPath, boolean append) throws IOException {
        File target = this.makeLocalPath(targetPath);
        return new FileOutputStream(target, append);
    }

    public void delete(String deletePath) throws IOException {
        File fileToDel = this.makeLocalPath(deletePath);
        boolean success = fileToDel.delete();
        if (!success) {
            throw new IOException("'" + this + "' failed to delete '" + deletePath + "' (don't know why, possibly file open/locked)");
        }
    }

    public InputStream getStream(String sourcePath) throws IOException {
        File source = this.makeLocalPath(sourcePath);
        return new FileInputStream(source);
    }

    public void copy(String sourcePath, Agsl target) throws IOException {
        FileInputStream in = new FileInputStream(this.makeLocalPath(sourcePath));
        OutputStream out = null;
        if (target.getEndpoint().equals("file://" + this.rootDir.getName())) {
            out = new FileOutputStream(this.makeLocalPath(target.getPath()), false);
        } else {
            StoreClient targetStore = StoreDelegateFactory.createDelegate(this.getOperator(), target);
            out = targetStore.putStream(target.getPath(), false);
        }
        Piper.bufferedPipe((InputStream)in, (OutputStream)out);
        ((InputStream)in).close();
        out.close();
    }

    protected File makeLocalPath(String path) {
        if (path != null) {
            path = path.replace(':', '_');
            path = path.replaceAll("\\\\", "_");
            path = path.replace(' ', '_');
            path = path.replace('?', '_');
            path = path.replace('&', '_');
            path = path.replace('=', '_');
        }
        return new File(this.rootDir, path);
    }

    public String toString() {
        return "LocalFileStore [" + this.rootDir.getName() + "]";
    }

    public void deleteUser(User delUser) {
        log.warn((Object)("User " + delUser + " filespace not deleted"));
    }

    public void createUser(User newUser) throws IOException {
        this.newFolder(newUser.getUserId() + "@" + newUser.getCommunity());
    }

    private class CriteriaFilenameFilter
    implements FilenameFilter {
        String criteria = null;

        public CriteriaFilenameFilter(String givenCriteria) {
            this.criteria = givenCriteria;
        }

        public boolean accept(File dir, String name) {
            if (this.criteria.equals("*")) {
                return true;
            }
            throw new UnsupportedOperationException();
        }
    }
}

