/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate.myspace;

import java.io.FileNotFoundException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.myspace.MySpaceFile;

public class MySpaceFolder
extends MySpaceFile {
    Hashtable children = new Hashtable();
    boolean isRoot = false;

    public MySpaceFolder(MySpaceFolder parent, String childName) {
        super(parent, childName);
    }

    public MySpaceFolder(String childName) {
        super(null, childName);
        this.isRoot = true;
    }

    public void add(StoreFile child) {
        this.children.put(child.getName(), child);
    }

    public StoreFile getChild(String filename) {
        return (StoreFile)this.children.get(filename);
    }

    public StoreFile[] listFiles() {
        return this.children.values().toArray(new StoreFile[0]);
    }

    public String getPath() {
        if (this.isRoot) {
            return "";
        }
        return this.getParent().getPath() + this.getName() + "/";
    }

    public String toString() {
        return this.getPath();
    }

    public StoreFile getParent() {
        return this.parentFolder;
    }

    public boolean isFolder() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(StoreFile anotherFile) {
        if (anotherFile instanceof MySpaceFolder) {
            return this.name.equals(((MySpaceFolder)anotherFile).name) && this.parentFolder.equals(((MySpaceFolder)anotherFile).parentFolder);
        }
        return false;
    }

    public StoreFile findFile(String path) throws FileNotFoundException {
        StringTokenizer dirTokens = new StringTokenizer(path, "/");
        MySpaceFolder folder = this;
        StoreFile child = null;
        while (dirTokens.hasMoreTokens()) {
            String token = dirTokens.nextToken();
            child = folder.getChild(token);
            if (child == null) {
                throw new FileNotFoundException("No such token '" + token + "' in path " + path + " from " + this);
            }
            if (!child.isFolder()) continue;
            folder = (MySpaceFolder)child;
        }
        if (dirTokens.hasMoreTokens()) {
            throw new FileNotFoundException("path " + path + " only partly found from " + this);
        }
        return child;
    }
}

