/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.delegate.myspaceItn05;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.rpc.ServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.User;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.Msrl;
import org.astrogrid.store.delegate.StoreAdminClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;
import org.astrogrid.store.delegate.StoreException;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.myspaceItn05.EntryResults;
import org.astrogrid.store.delegate.myspaceItn05.KernelResults;
import org.astrogrid.store.delegate.myspaceItn05.Manager;
import org.astrogrid.store.delegate.myspaceItn05.ManagerServiceLocator;
import org.astrogrid.store.delegate.myspaceItn05.MySpaceFileType;
import org.astrogrid.store.delegate.myspaceItn05.StatusMessage;
import org.astrogrid.store.delegate.myspaceItn05.StatusResults;

public class MySpaceIt05Delegate
implements StoreClient,
StoreAdminClient {
    private static final Log log;
    private Manager innerDelegate = null;
    private Msrl managerMsrl = null;
    private User operator = null;
    private boolean isTest = false;
    private boolean throwExceptions = true;
    private boolean allowOverWrite = true;
    private ArrayList statusList = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public MySpaceIt05Delegate(User givenOperator, String givenEndPoint) throws IOException {
        this.operator = givenOperator;
        if (!givenEndPoint.startsWith("myspace")) {
            givenEndPoint = "myspace:" + givenEndPoint;
        }
        this.managerMsrl = new Msrl(givenEndPoint);
        log.debug((Object)("the endpoint in myspaceitn05delegate = " + this.managerMsrl.getDelegateEndpoint()));
        try {
            ManagerServiceLocator service = new ManagerServiceLocator();
            this.innerDelegate = service.getAstrogridMyspace(this.managerMsrl.getDelegateEndpoint());
        }
        catch (ServiceException e) {
            throw new IOException("Failed to connect to: " + givenEndPoint);
        }
    }

    public void setTest(boolean isTest) {
        this.isTest = isTest;
    }

    public void setThrow(boolean throwExceptions) {
        this.throwExceptions = throwExceptions;
    }

    public void setOverWrite(boolean allowOverWrite) {
        this.allowOverWrite = allowOverWrite;
    }

    public ArrayList getStatusList() {
        return this.statusList;
    }

    public void outputStatusList() {
        int numMessages = this.statusList.size();
        if (numMessages > 0) {
            for (int loop = 0; loop < numMessages; ++loop) {
                StatusMessage message = (StatusMessage)this.statusList.get(loop);
                log.debug((Object)message.toString());
            }
        } else {
            log.debug((Object)"No messages returned.");
        }
    }

    public void resetStatusList() {
        this.statusList.clear();
    }

    public User getOperator() {
        return this.operator;
    }

    public Agsl getEndpoint() {
        Agsl agsl = new Agsl(this.managerMsrl);
        return agsl;
    }

    public String getNameOf(EntryResults entryResult) {
        String path = entryResult.getEntryName();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length());
        }
        if (path.lastIndexOf("/") == -1) {
            return path;
        }
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getParentPathOf(EntryResults entryResult) {
        String fullPath = entryResult.getEntryName();
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length());
        }
        if (fullPath.lastIndexOf("/") == -1) {
            return "";
        }
        return fullPath.substring(0, fullPath.lastIndexOf("/"));
    }

    public StoreFile makeStoreFile(MySpaceFolder parent, EntryResults result) {
        MySpaceFile file;
        System.out.println("FROG : makeStoreFile()");
        System.out.println("  Name : " + result.getEntryName());
        System.out.println("  Size : " + result.getSize());
        if (result.getType() == 1) {
            file = parent == null ? new MySpaceFolder() : new MySpaceFolder(parent, result);
        } else if (parent == null) {
            parent = new MySpaceFolder(this.getParentPathOf(result));
            file = new MySpaceFile(parent, result);
        } else {
            file = new MySpaceFile(parent, result);
        }
        System.out.println("  Size : " + file.getSize());
        return file;
    }

    public StoreFile getFiles(String filter) throws IOException {
        KernelResults results = this.innerDelegate.getEntriesList(filter, this.isTest);
        this.appendAndCheckStatusMessages(results);
        if (results == null) {
            return null;
        }
        Object[] fileList = results.getEntries();
        if (fileList == null) {
            return null;
        }
        MySpaceFolder root = new MySpaceFolder();
        for (int r = 0; r < fileList.length; ++r) {
            MySpaceFolder parentFolder;
            EntryResults result = (EntryResults)fileList[r];
            String path = result.getEntryName();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.indexOf("/") == -1) {
                parentFolder = root;
            } else {
                String parentPath = path.substring(0, path.lastIndexOf("/"));
                parentFolder = (MySpaceFolder)root.findFile(parentPath);
            }
            StoreFile file = this.makeStoreFile(parentFolder, result);
            parentFolder.add(file);
        }
        return root;
    }

    public StoreFile getFile(String path) throws IOException {
        System.out.println("FROG : getFile()");
        System.out.println("  Path : " + path);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        KernelResults results = this.innerDelegate.getEntriesList(path, this.isTest);
        this.appendAndCheckStatusMessages(results);
        if (results.getEntries() == null) {
            return null;
        }
        return this.makeStoreFile(null, (EntryResults)results.getEntries()[0]);
    }

    public Agsl getAgsl(String sourcePath) throws IOException {
        if (!$assertionsDisabled && (sourcePath.endsWith("/") || sourcePath.endsWith("\\"))) {
            throw new AssertionError((Object)"Cannot create AGSLs for folders (yet)");
        }
        return new Agsl(this.getEndpoint(), sourcePath);
    }

    public void putBytes(byte[] bytes, int offset, int length, String targetPath, boolean append) throws IOException {
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        int dispatchExisting = 1;
        dispatchExisting = append ? 3 : (this.allowOverWrite ? 2 : 1);
        int numBytes = length - offset;
        byte[] subsetToSend = new byte[length];
        for (int loop = 0; loop < numBytes; ++loop) {
            subsetToSend[loop] = bytes[loop + offset];
        }
        KernelResults results = this.innerDelegate.putBytes(targetPath, subsetToSend, 0, dispatchExisting, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void putString(String contents, String targetPath, boolean append) throws IOException {
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        int dispatchExisting = 1;
        dispatchExisting = append ? 3 : (this.allowOverWrite ? 2 : 1);
        KernelResults results = this.innerDelegate.putString(targetPath, contents, 0, dispatchExisting, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void putUrl(URL source, String targetPath, boolean append) throws IOException {
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        int dispatchExisting = 1;
        dispatchExisting = append ? 3 : (this.allowOverWrite ? 2 : 1);
        String uri = source.toString();
        KernelResults results = this.innerDelegate.putUri(targetPath, uri, 0, dispatchExisting, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public OutputStream putStream(String targetPath, boolean append) throws IOException {
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        return new MySpaceOutputStream(targetPath, append);
    }

    public InputStream getStream(String sourcePath) throws IOException {
        URL url;
        if (!sourcePath.startsWith("/")) {
            sourcePath = "/" + sourcePath;
        }
        if ((url = this.getUrl(sourcePath)) == null) {
            throw new FileNotFoundException("Failed to find URL for path: " + sourcePath + " on " + this.managerMsrl);
        }
        return url.openStream();
    }

    public URL getUrl(String path) throws IOException {
        System.out.println("");
        System.out.println("MySPaceDeletage.getUrl");
        System.out.println("  Path : " + path);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        KernelResults results = this.innerDelegate.getEntriesList(path, this.isTest);
        this.appendAndCheckStatusMessages(results);
        if (results == null || results.getEntries() == null) {
            return null;
        }
        Object[] entries = results.getEntries();
        EntryResults entry = (EntryResults)entries[0];
        URL url = new URL(entry.getEntryUri());
        System.out.println("  URL  : " + url.toString());
        String host = url.getHost();
        System.out.println("  Host : " + host);
        if (host.equalsIgnoreCase("localhost")) {
            String protocol = url.getProtocol();
            int port = url.getPort();
            String urlPath = url.getPath();
            try {
                InetAddress addr = InetAddress.getLocalHost();
                String fullHostName = addr.getCanonicalHostName();
                url = new URL(protocol, fullHostName, port, urlPath);
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        System.out.println("  URL  : " + url.toString());
        return url;
    }

    public void delete(String deletePath) throws IOException {
        if (!deletePath.startsWith("/")) {
            deletePath = "/" + deletePath;
        }
        KernelResults results = this.innerDelegate.deleteFile(deletePath, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void copy(String sourcePath, Agsl target) throws IOException {
        System.out.println("----");
        System.out.println("MySpaceIt05Delegate.copy");
        System.out.println("  Source path : '" + sourcePath + "'");
        System.out.println("  Target agsl : '" + target.toString() + "'");
        URL url = this.getUrl(sourcePath);
        System.out.println("  Source URL  : '" + url.toString() + "'");
        System.out.println("");
        System.out.println("Creating target delegate ....");
        StoreClient targetStore = StoreDelegateFactory.createDelegate(this.operator, target);
        System.out.println("Done");
        System.out.println("");
        System.out.println("Calling target delegate ....");
        targetStore.putUrl(url, target.getPath(), false);
        System.out.println("Done");
    }

    public void copy(Agsl source, String targetPath) throws IOException {
        if (source.getEndpoint().equals(this.getEndpoint())) {
            String sourcePath = source.getPath();
            if (!targetPath.startsWith("/")) {
                targetPath = "/" + targetPath;
            }
            if (!sourcePath.startsWith("/")) {
                sourcePath = "/" + sourcePath;
            }
            KernelResults results = this.innerDelegate.copyFile(sourcePath, targetPath, this.isTest);
            this.appendAndCheckStatusMessages(results);
        } else {
            StoreClient sourceStore = StoreDelegateFactory.createDelegate(this.operator, source);
            this.putUrl(sourceStore.getUrl(source.getPath()), targetPath, false);
        }
    }

    public void move(String sourcePath, Agsl target) throws IOException {
        this.copy(sourcePath, target);
        this.delete(sourcePath);
    }

    public void move(Agsl source, String targetPath) throws IOException {
        this.copy(source, targetPath);
        StoreDelegateFactory.createDelegate(this.operator, source);
    }

    public void newFolder(String targetPath) throws IOException {
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        KernelResults results = this.innerDelegate.createContainer(targetPath, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void createUser(User newAccount) throws IOException {
        String account = newAccount.getUserId();
        KernelResults results = this.innerDelegate.createAccount(account, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void deleteUser(User deadAccount) throws IOException {
        String account = deadAccount.getUserId();
        KernelResults results = this.innerDelegate.deleteAccount(account, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public boolean heartBeat() throws IOException {
        boolean response = false;
        try {
            String result = this.innerDelegate.heartBeat();
            if (result.equals("Adsum.")) {
                response = true;
            }
        }
        catch (Exception all) {
            response = false;
        }
        return response;
    }

    public String getString(String targetPath) throws IOException {
        KernelResults results;
        String contents = "";
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        if ((results = this.innerDelegate.getString(targetPath, this.isTest)).getContentsString() != null) {
            contents = results.getContentsString();
        }
        this.appendAndCheckStatusMessages(results);
        return contents;
    }

    public byte[] getBytes(String targetPath) throws IOException {
        KernelResults results;
        byte[] contents = null;
        if (!targetPath.startsWith("/")) {
            targetPath = "/" + targetPath;
        }
        if ((results = this.innerDelegate.getBytes(targetPath, this.isTest)).getContentsBytes() != null) {
            contents = results.getContentsBytes();
        }
        this.appendAndCheckStatusMessages(results);
        return contents;
    }

    public void extendLifetime(String fileName, Date newExpiryDate) throws IOException {
        long expiry = newExpiryDate.getTime();
        KernelResults results = this.innerDelegate.extendLifetime(fileName, expiry, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    public void changeOwner(String path, User newOwner) throws IOException {
        String owner = newOwner.getAccount();
        KernelResults results = this.innerDelegate.changeOwner(path, owner, this.isTest);
        this.appendAndCheckStatusMessages(results);
    }

    private void appendAndCheckStatusMessages(KernelResults results) throws StoreException {
        boolean errorRaised = false;
        String messageFromManager = "none.";
        Object[] statusResults = results.getStatusList();
        int numStatus = Array.getLength(statusResults);
        if (numStatus > 0) {
            StatusMessage status = new StatusMessage();
            for (int loop = 0; loop < numStatus; ++loop) {
                status = new StatusMessage((StatusResults)statusResults[loop]);
                this.statusList.add(status);
                if (status.getSeverity() != 3) continue;
                if (!errorRaised) {
                    messageFromManager = status.getMessage();
                }
                errorRaised = true;
            }
        }
        if (errorRaised && this.throwExceptions) {
            throw new StoreException(messageFromManager);
        }
    }

    static {
        $assertionsDisabled = !MySpaceIt05Delegate.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)MySpaceIt05Delegate.class);
    }

    private class MySpaceFolder
    extends MySpaceFile {
        Hashtable children;
        boolean isRoot;

        public MySpaceFolder(MySpaceFolder parent, EntryResults bindingEntry) {
            super(parent, bindingEntry);
            this.children = new Hashtable();
            this.isRoot = false;
        }

        public MySpaceFolder() {
            this.children = new Hashtable();
            this.isRoot = false;
            this.isRoot = true;
        }

        public MySpaceFolder(String givenPath) {
            this.children = new Hashtable();
            this.isRoot = false;
            if (givenPath.startsWith("/")) {
                givenPath = givenPath.substring(1);
            }
            this.name = givenPath;
        }

        public void add(StoreFile child) {
            this.children.put(child.getName(), child);
        }

        public StoreFile getChild(String filename) {
            return (StoreFile)this.children.get(filename);
        }

        public StoreFile[] listFiles() {
            return this.children.values().toArray(new StoreFile[0]);
        }

        public String getPath() {
            if (this.isRoot) {
                return "";
            }
            if (this.getParent() == null) {
                return this.getName() + "/";
            }
            return this.getParent().getPath() + this.getName() + "/";
        }

        public boolean isFolder() {
            return true;
        }

        public boolean isFile() {
            return false;
        }

        public StoreFile findFile(String path) throws FileNotFoundException {
            StringTokenizer dirTokens = new StringTokenizer(path, "/");
            MySpaceFolder folder = this;
            StoreFile child = null;
            while (dirTokens.hasMoreTokens()) {
                String token = dirTokens.nextToken();
                child = folder.getChild(token);
                if (child == null) {
                    throw new FileNotFoundException("No such token '" + token + "' in path '" + path + "' from " + this);
                }
                if (!child.isFolder()) continue;
                folder = (MySpaceFolder)child;
            }
            if (dirTokens.hasMoreTokens()) {
                throw new FileNotFoundException("path " + path + " only partly found from " + this);
            }
            return child;
        }
    }

    private class MySpaceFile
    implements StoreFile {
        String name = null;
        String owner = null;
        Date created = null;
        Date expires = null;
        long size = -1L;
        String permissions = null;
        URL url = null;
        String mime = null;
        MySpaceFileType type = null;
        MySpaceFolder parentFolder = null;

        private MySpaceFile() {
        }

        public MySpaceFile(MySpaceFolder parent, EntryResults bindingEntry) {
            this.parentFolder = parent;
            this.name = MySpaceIt05Delegate.this.getNameOf(bindingEntry);
            this.owner = bindingEntry.getOwnerId();
            this.created = new Date(bindingEntry.getCreationDate());
            this.expires = new Date(bindingEntry.getExpiryDate());
            this.size = bindingEntry.getSize();
            this.permissions = bindingEntry.getPermissionsMask();
            this.mime = bindingEntry.getMime();
            this.type = MySpaceFileType.getForManagerRef(bindingEntry.getType());
            try {
                this.url = new URL(bindingEntry.getEntryUri());
            }
            catch (MalformedURLException mue) {
                log.error((Object)("Server returned invalid URL " + bindingEntry.getEntryUri() + " for entry " + bindingEntry.getEntryName()));
            }
        }

        public String getType() {
            return this.type.toString();
        }

        public String toString() {
            return this.getName();
        }

        public String getOwner() {
            return this.owner;
        }

        public Date getCreated() {
            return this.created;
        }

        public Date getExpires() {
            return this.expires;
        }

        public long getSize() {
            return this.size;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public String getMimeType() {
            return this.mime;
        }

        public Date getModified() {
            return null;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getPath() {
            return this.getParent().getPath() + this.name;
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isFile() {
            return true;
        }

        public String getName() {
            return this.name;
        }

        public StoreFile getParent() {
            return this.parentFolder;
        }

        public StoreFile[] listFiles() {
            return null;
        }

        public boolean equals(StoreFile anotherFile) {
            if (anotherFile instanceof MySpaceFile) {
                return this.name.equals(((MySpaceFile)anotherFile).name) && this.parentFolder.equals(((MySpaceFile)anotherFile).parentFolder);
            }
            return false;
        }
    }

    private class MySpaceOutputStream
    extends OutputStream {
        private String targetPath = null;
        private byte[] buffer = new byte[32000];
        private int cursor = 0;

        public MySpaceOutputStream(String aTargetPath, boolean append) throws IOException {
            this.targetPath = aTargetPath;
            if (!append) {
                MySpaceIt05Delegate.this.putString("", this.targetPath, false);
            }
        }

        public void write(int i) throws IOException {
            this.buffer[this.cursor] = (byte)(i & 0xFF);
            ++this.cursor;
            if (this.cursor >= this.buffer.length) {
                this.flush();
            }
        }

        public void flush() throws IOException {
            MySpaceIt05Delegate.this.putBytes(this.buffer, 0, this.cursor, this.targetPath, true);
            this.cursor = 0;
        }

        public String toString() {
            return "MySpaceOutputStream [" + MySpaceIt05Delegate.this.managerMsrl + "#" + this.targetPath + "]";
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }
}

