/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.tree;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.User;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.resolver.CommunityAccountSpaceResolver;
import org.astrogrid.community.resolver.CommunityPasswordResolver;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.VoSpaceClient;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.tree.Container;
import org.astrogrid.store.tree.File;
import org.astrogrid.store.tree.Node;
import org.astrogrid.store.tree.TreeClient;
import org.astrogrid.store.tree.TreeClientDuplicateException;
import org.astrogrid.store.tree.TreeClientLoginException;
import org.astrogrid.store.tree.TreeClientSecurityException;
import org.astrogrid.store.tree.TreeClientServiceException;

public class IterationSixTreeClient
implements TreeClient {
    private static final Log logger;
    protected SecurityToken token;
    protected final CommunityPasswordResolver security = new CommunityPasswordResolver();
    protected final CommunityAccountSpaceResolver spaceResolver = new CommunityAccountSpaceResolver();
    protected StoreClient client;
    protected String username;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void login(Ivorn communityIvorn, String password) throws TreeClientLoginException, TreeClientServiceException {
        if (communityIvorn == null) {
            throw new IllegalArgumentException("Null account");
        }
        if (password == null) {
            throw new IllegalArgumentException("Null password");
        }
        logger.info((Object)("Logging in " + communityIvorn));
        try {
            logger.info((Object)"Checking password");
            this.token = this.security.checkPassword(communityIvorn.toString(), password);
            logger.debug((Object)this.token);
            CommunityIvornParser ivornParser = new CommunityIvornParser(this.token.getAccount());
            logger.info((Object)"user object");
            this.username = ivornParser.getAccountName();
            User u = new User();
            u.setAccount(this.username + "@" + ivornParser.getCommunityName());
            u.setToken(this.token.getToken());
            logger.debug((Object)u);
            logger.info((Object)"Creating vospace client");
            VoSpaceClient voSpace = new VoSpaceClient(u);
            logger.info((Object)"Creating Store Client");
            Ivorn vospaceIvorn = this.spaceResolver.resolve(communityIvorn);
            logger.debug((Object)vospaceIvorn);
            if (vospaceIvorn.toString().endsWith("null")) {
                String s = vospaceIvorn.toString();
                vospaceIvorn = new Ivorn(s.substring(0, s.lastIndexOf("null")));
                logger.warn((Object)("mangled vospaceIvorn to " + vospaceIvorn));
            }
            this.client = voSpace.getDelegate(vospaceIvorn);
            logger.debug((Object)this.client);
        }
        catch (CommunitySecurityException e) {
            logger.info((Object)"login failed", (Throwable)e);
            throw new TreeClientLoginException("Login failed", e);
        }
        catch (CommunityServiceException e) {
            logger.info((Object)"login failed", (Throwable)e);
            throw new TreeClientLoginException("Login failed", e);
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to perform request", e);
            throw new TreeClientServiceException("Failed to perform request", e);
        }
    }

    public StoreClient getStoreClient() {
        return this.client;
    }

    public void logout() throws TreeClientServiceException {
        logger.info((Object)"logging out");
        this.token = null;
        this.client = null;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public Container getRoot() throws TreeClientSecurityException, TreeClientServiceException {
        if (this.token == null) {
            throw new TreeClientSecurityException("Not logged in");
        }
        try {
            String rootPath = "/" + this.username + "*";
            logger.info((Object)("Getting root via query " + rootPath));
            StoreFile container = this.client.getFiles(rootPath);
            if (!$assertionsDisabled && container == null) {
                throw new AssertionError((Object)"Null container returned");
            }
            StoreFile[] children = container.listFiles();
            if (!$assertionsDisabled && children.length != 1) {
                throw new AssertionError((Object)"Found multiple roots");
            }
            StoreFile root = children[0];
            if (!$assertionsDisabled && root == null) {
                throw new AssertionError((Object)"Root is null");
            }
            return new IterationSixContainer(root);
        }
        catch (IOException e) {
            logger.fatal((Object)"could not get root", (Throwable)e);
            throw new TreeClientServiceException("Could not get root", e);
        }
    }

    protected String dropTrailingSlash(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    static {
        $assertionsDisabled = !IterationSixTreeClient.class.desiredAssertionStatus();
        logger = LogFactory.getLog((Class)IterationSixTreeClient.class);
    }

    protected class IterationSixFile
    extends IterationSixNode
    implements File {
        public IterationSixFile(StoreFile wrapped) {
            super(wrapped);
        }

        public String getMimeType() {
            return this.wrapped.getMimeType();
        }

        public OutputStream getOutputStream() throws TreeClientServiceException {
            try {
                return IterationSixTreeClient.this.client.putStream(this.getPath(), false);
            }
            catch (IOException e) {
                logger.error((Object)("Could not get output stream for " + this.getPath()), (Throwable)e);
                throw new TreeClientServiceException("Could not get output stream for " + this.getPath(), e);
            }
        }

        public InputStream getInputStream() throws TreeClientServiceException {
            try {
                return IterationSixTreeClient.this.client.getStream(this.getPath());
            }
            catch (IOException e) {
                logger.error((Object)("Could not get input stream for " + this.getPath()), (Throwable)e);
                throw new TreeClientServiceException("Could not get input stream for " + this.getPath(), e);
            }
        }
    }

    protected class IterationSixContainer
    extends IterationSixNode
    implements Container {
        private Map childMap;

        public IterationSixContainer(StoreFile wrapped) {
            super(wrapped);
            this.buildChildren();
        }

        private final void buildChildren() {
            StoreFile[] children = this.wrapped.listFiles();
            this.childMap = new HashMap(children.length);
            for (int i = 0; i < children.length; ++i) {
                StoreFile f = children[i];
                logger.debug((Object)("found child:" + f.getName()));
                IterationSixNode n = f.isFile() ? new IterationSixFile(f) : new IterationSixContainer(f);
                this.childMap.put(n.getName(), n);
            }
        }

        public Collection getChildNodes() {
            return Collections.unmodifiableCollection(this.childMap.values());
        }

        public Container addContainer(String name) throws TreeClientServiceException, TreeClientDuplicateException {
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("Cannot create unnamed container");
            }
            String targetPath = this.getPath() + "/" + name.trim();
            logger.info((Object)("Will add container " + targetPath));
            try {
                if (IterationSixTreeClient.this.client.getFile(targetPath) != null) {
                    logger.info((Object)("duplicate of " + targetPath + " found"));
                    throw new TreeClientDuplicateException(targetPath);
                }
                IterationSixTreeClient.this.client.newFolder(targetPath);
                IterationSixNode newFolder = this.findNewNode(targetPath);
                this.childMap.put(newFolder.getName(), newFolder);
                return (Container)((Object)newFolder);
            }
            catch (IOException e) {
                logger.error((Object)("addContainer(" + targetPath + ")"), (Throwable)e);
                throw new TreeClientServiceException("addContainer(" + targetPath + ")", e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public File addFile(String name) throws TreeClientServiceException, TreeClientDuplicateException {
            File file;
            if (name == null) throw new IllegalArgumentException("Cannot create unnamed file");
            if (name.trim().length() == 0) {
                throw new IllegalArgumentException("Cannot create unnamed file");
            }
            String targetPath = this.getPath() + "/" + name.trim();
            logger.info((Object)("Will add file " + targetPath));
            OutputStream os = null;
            try {
                try {
                    if (IterationSixTreeClient.this.client.getFile(targetPath) != null) {
                        logger.info((Object)("duplicate of " + targetPath + " found"));
                        throw new TreeClientDuplicateException(targetPath);
                    }
                    os = IterationSixTreeClient.this.client.putStream(targetPath, false);
                    IterationSixNode newFile = this.findNewNode(targetPath);
                    this.childMap.put(newFile.getName(), newFile);
                    file = (File)((Object)newFile);
                    Object var7_7 = null;
                    if (os == null) return file;
                }
                catch (IOException e) {
                    logger.error((Object)("addFile(" + targetPath + ")"), (Throwable)e);
                    throw new TreeClientServiceException("addFile(" + targetPath + ")", e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.warn((Object)"failed to close output stream", (Throwable)e2);
                    throw throwable;
                }
            }
            try {}
            catch (IOException e2) {
                logger.warn((Object)"failed to close output stream", (Throwable)e2);
                return file;
            }
            os.close();
            return file;
        }

        private IterationSixNode findNewNode(String targetPath) throws TreeClientServiceException {
            try {
                StringTokenizer tok = new StringTokenizer(targetPath, "/");
                tok.nextToken();
                IterationSixNode current = (IterationSixNode)((Object)IterationSixTreeClient.this.getRoot());
                while (tok.hasMoreTokens()) {
                    String name = tok.nextToken();
                    current = (IterationSixNode)((IterationSixContainer)current).childMap.get(name);
                }
                return current;
            }
            catch (TreeClientSecurityException e) {
                logger.fatal((Object)"findNewNode - not logged in", (Throwable)e);
                throw new IllegalStateException("find new Node - not logged in");
            }
        }
    }

    protected class IterationSixNode
    implements Node {
        protected final StoreFile wrapped;
        protected final String path;

        public IterationSixNode(StoreFile wrapped, String path) {
            this.wrapped = wrapped;
            this.path = path;
            logger.debug((Object)("Creating iteration six node for:" + path));
        }

        public IterationSixNode(StoreFile wrapped) {
            this(wrapped, "/" + this$0.dropTrailingSlash(wrapped.getPath()).trim());
        }

        public String getName() {
            return this.wrapped.getName().trim();
        }

        public boolean isFile() {
            return this.wrapped.isFile();
        }

        public boolean isContainer() {
            return this.wrapped.isFolder();
        }

        protected String getPath() {
            return this.path;
        }

        public boolean equals(Object obj) {
            IterationSixNode casted = (IterationSixNode)obj;
            return this.getPath().equals(casted.getPath());
        }

        public String toString() {
            return "Node (IterationSix) for " + (this.isFile() ? "file " : "folder ") + this.getPath();
        }
    }
}

