/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.tree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.collection.UnmodifiableCollection;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.ivorn.CommunityIvornParser;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.common.security.service.SecurityServiceMock;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.tree.Container;
import org.astrogrid.store.tree.File;
import org.astrogrid.store.tree.TreeClient;
import org.astrogrid.store.tree.TreeClientDuplicateException;
import org.astrogrid.store.tree.TreeClientLoginException;
import org.astrogrid.store.tree.TreeClientSecurityException;
import org.astrogrid.store.tree.TreeClientServiceException;
import org.astrogrid.store.util.MimeTypeUtil;

public class TreeClientMock
implements TreeClient {
    private Ivorn account;
    SecurityServiceMock security = new SecurityServiceMock();
    private SecurityToken token;
    private Map myspace = new HashMap();

    public void setTestAccount(Ivorn ivorn) {
        this.account = ivorn;
    }

    public void setTestPassword(String password) {
        SecurityServiceMock.setPassword((String)password);
    }

    public void login(Ivorn ivorn, String password) throws TreeClientLoginException, TreeClientServiceException {
        if (null == ivorn) {
            throw new IllegalArgumentException("Null account");
        }
        if (null == password) {
            throw new IllegalArgumentException("Null password");
        }
        try {
            this.token = null;
            this.token = this.security.checkPassword(ivorn.toString(), password);
            this.init();
        }
        catch (CommunitySecurityException ouch) {
            throw new TreeClientLoginException("Login failed", ouch);
        }
        catch (Throwable ouch) {
            throw new TreeClientServiceException("Failed to perform request", ouch);
        }
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public void logout() {
        this.token = null;
    }

    public Container getRoot() throws TreeClientSecurityException, TreeClientServiceException {
        if (null == this.token) {
            throw new TreeClientSecurityException("Not logged in");
        }
        return (Container)this.myspace.get(this.token.getAccount());
    }

    private void init() throws TreeClientServiceException {
        if (null != this.token && !this.myspace.containsKey(this.token.getAccount())) {
            try {
                CommunityIvornParser parser = new CommunityIvornParser(this.token.getAccount());
                MockContainer root = new MockContainer(parser.getAccountName());
                root.addContainer("workflow");
                this.myspace.put(this.token.getAccount(), root);
            }
            catch (Exception ouch) {
                throw new TreeClientServiceException("Failed to initialise account space", ouch);
            }
        }
    }

    public class MockFile
    implements File {
        private String name;
        private byte[] data = new byte[0];

        public MockFile(String name) {
            if (null == name) {
                throw new IllegalArgumentException("Null file name");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isFile() {
            return true;
        }

        public boolean isContainer() {
            return false;
        }

        public String getMimeType() {
            MimeTypeUtil util = new MimeTypeUtil();
            return util.resolve(this.getName());
        }

        public OutputStream getOutputStream() {
            return new ByteArrayOutputStream(this){
                private final /* synthetic */ MockFile this$1;
                {
                    this.this$1 = this$1;
                }

                public void close() {
                    MockFile.access$002(this.this$1, this.toByteArray());
                }
            };
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        static /* synthetic */ byte[] access$002(MockFile x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    public class MockContainer
    implements Container {
        private String name;
        private Map nodes = new HashMap();

        public MockContainer(String name) {
            if (null == name) {
                throw new IllegalArgumentException("Null container name");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isFile() {
            return false;
        }

        public boolean isContainer() {
            return true;
        }

        public Collection getChildNodes() {
            return UnmodifiableCollection.decorate(this.nodes.values());
        }

        public Container addContainer(String name) throws TreeClientDuplicateException {
            if (this.nodes.containsKey(name)) {
                throw new TreeClientDuplicateException();
            }
            MockContainer node = new MockContainer(name);
            this.nodes.put(name, node);
            return node;
        }

        public File addFile(String name) throws TreeClientDuplicateException {
            if (this.nodes.containsKey(name)) {
                throw new TreeClientDuplicateException();
            }
            MockFile node = new MockFile(name);
            this.nodes.put(name, node);
            return node;
        }
    }
}

